<?php

namespace cycro\EnumType;

/**
 * This class stands for function EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Blockable functions, possible values are:LOCKDZB = delivery to a third party with notification of deliveryLOCKASG = written permission to deposit goodsLOCKEVM = delivery with non-recurring authorityLOCKSHOP = parcel shopLOCKTV =
 * appointment
 * @subpackage Enumerations
 */
class _function
{
    /**
     * Constant for value 'LOCKDZB'
     * @return string 'LOCKDZB'
     */
    const VALUE_LOCKDZB = 'LOCKDZB';
    /**
     * Constant for value 'LOCKASG'
     * @return string 'LOCKASG'
     */
    const VALUE_LOCKASG = 'LOCKASG';
    /**
     * Constant for value 'LOCKEVM'
     * @return string 'LOCKEVM'
     */
    const VALUE_LOCKEVM = 'LOCKEVM';
    /**
     * Constant for value 'LOCKSHOP'
     * @return string 'LOCKSHOP'
     */
    const VALUE_LOCKSHOP = 'LOCKSHOP';
    /**
     * Constant for value 'LOCKTV'
     * @return string 'LOCKTV'
     */
    const VALUE_LOCKTV = 'LOCKTV';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LOCKDZB
     * @uses self::VALUE_LOCKASG
     * @uses self::VALUE_LOCKEVM
     * @uses self::VALUE_LOCKSHOP
     * @uses self::VALUE_LOCKTV
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOCKDZB,
            self::VALUE_LOCKASG,
            self::VALUE_LOCKEVM,
            self::VALUE_LOCKSHOP,
            self::VALUE_LOCKTV,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
