<?php

namespace cycro\EnumType;

/**
 * This class stands for linehaul EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Defines mode of line haul. Possible values are "AI" for air and "RO" for road.
 * @subpackage Enumerations
 */
class Linehaul
{
    /**
     * Constant for value 'AI'
     * @return string 'AI'
     */
    const VALUE_AI = 'AI';
    /**
     * Constant for value 'RO'
     * @return string 'RO'
     */
    const VALUE_RO = 'RO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AI
     * @uses self::VALUE_RO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AI,
            self::VALUE_RO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
