<?php

namespace cycro;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'storeOrders' => '\\cycro\\StructType\\StoreOrders',
            'storeOrdersResponse' => '\\cycro\\StructType\\StoreOrdersResponse',
            'storeOrdersResponseType' => '\\cycro\\StructType\\StoreOrdersResponseType',
            'shipmentResponse' => '\\cycro\\StructType\\ShipmentResponse',
            'shipmentServiceData' => '\\cycro\\StructType\\ShipmentServiceData',
            'generalShipmentData' => '\\cycro\\StructType\\GeneralShipmentData',
            'address' => '\\cycro\\StructType\\Address',
            'parcel' => '\\cycro\\StructType\\Parcel',
            'productAndServiceData' => '\\cycro\\StructType\\ProductAndServiceData',
            'international' => '\\cycro\\StructType\\International',
            'delivery' => '\\cycro\\StructType\\Delivery',
            'proactiveNotification' => '\\cycro\\StructType\\ProactiveNotification',
            'notification' => '\\cycro\\StructType\\Notification',
            'cod' => '\\cycro\\StructType\\Cod',
            'hazardous' => '\\cycro\\StructType\\Hazardous',
            'personalDelivery' => '\\cycro\\StructType\\PersonalDelivery',
            'pickup' => '\\cycro\\StructType\\Pickup',
            'parcelInformationType' => '\\cycro\\StructType\\ParcelInformationType',
            'faultCodeType' => '\\cycro\\StructType\\FaultCodeType',
            'higherInsurance' => '\\cycro\\StructType\\HigherInsurance',
            'parcelShopDelivery' => '\\cycro\\StructType\\ParcelShopDelivery',
            'printOptions' => '\\cycro\\StructType\\PrintOptions',
            'printer' => '\\cycro\\StructType\\Printer',
            'authentication' => '\\cycro\\StructType\\Authentication',
            'authenticationFault' => '\\cycro\\StructType\\AuthenticationFault',
        );
    }
}
