<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeOrdersResponseType StructType
 * @subpackage Structs
 */
class StoreOrdersResponseType extends AbstractStructBase
{
    /**
     * The parcellabelsPDF
     * Meta informations extracted from the WSDL
     * - documentation: Contains parcel label PDF data in bytes.
     * - minOccurs: 0
     * @var string
     */
    public $parcellabelsPDF;
    /**
     * The shipmentResponses
     * Meta informations extracted from the WSDL
     * - documentation: Contains response data for every shipment order.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cycro\StructType\ShipmentResponse[]
     */
    public $shipmentResponses;
    /**
     * Constructor method for storeOrdersResponseType
     * @uses StoreOrdersResponseType::setParcellabelsPDF()
     * @uses StoreOrdersResponseType::setShipmentResponses()
     * @param string $parcellabelsPDF
     * @param \cycro\StructType\ShipmentResponse[] $shipmentResponses
     */
    public function __construct($parcellabelsPDF = null, array $shipmentResponses = array())
    {
        $this
            ->setParcellabelsPDF($parcellabelsPDF)
            ->setShipmentResponses($shipmentResponses);
    }
    /**
     * Get parcellabelsPDF value
     * @return string|null
     */
    public function getParcellabelsPDF()
    {
        return $this->parcellabelsPDF;
    }
    /**
     * Set parcellabelsPDF value
     * @param string $parcellabelsPDF
     * @return \cycro\StructType\StoreOrdersResponseType
     */
    public function setParcellabelsPDF($parcellabelsPDF = null)
    {
        // validation for constraint: string
        if (!is_null($parcellabelsPDF) && !is_string($parcellabelsPDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parcellabelsPDF)), __LINE__);
        }
        $this->parcellabelsPDF = $parcellabelsPDF;
        return $this;
    }
    /**
     * Get shipmentResponses value
     * @return \cycro\StructType\ShipmentResponse[]|null
     */
    public function getShipmentResponses()
    {
        return $this->shipmentResponses;
    }
    /**
     * Set shipmentResponses value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\ShipmentResponse[] $shipmentResponses
     * @return \cycro\StructType\StoreOrdersResponseType
     */
    public function setShipmentResponses(array $shipmentResponses = array())
    {
        foreach ($shipmentResponses as $storeOrdersResponseTypeShipmentResponsesItem) {
            // validation for constraint: itemType
            if (!$storeOrdersResponseTypeShipmentResponsesItem instanceof \cycro\StructType\ShipmentResponse) {
                throw new \InvalidArgumentException(sprintf('The shipmentResponses property can only contain items of \cycro\StructType\ShipmentResponse, "%s" given', is_object($storeOrdersResponseTypeShipmentResponsesItem) ? get_class($storeOrdersResponseTypeShipmentResponsesItem) : gettype($storeOrdersResponseTypeShipmentResponsesItem)), __LINE__);
            }
        }
        $this->shipmentResponses = $shipmentResponses;
        return $this;
    }
    /**
     * Add item to shipmentResponses value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\ShipmentResponse $item
     * @return \cycro\StructType\StoreOrdersResponseType
     */
    public function addToShipmentResponses(\cycro\StructType\ShipmentResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cycro\StructType\ShipmentResponse) {
            throw new \InvalidArgumentException(sprintf('The shipmentResponses property can only contain items of \cycro\StructType\ShipmentResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->shipmentResponses[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\StoreOrdersResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
