<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shipmentServiceData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bundles shipment service data.
 * @subpackage Structs
 */
class ShipmentServiceData extends AbstractStructBase
{
    /**
     * The generalShipmentData
     * Meta informations extracted from the WSDL
     * - documentation: Contains general data for a shipment.
     * - minOccurs: 1
     * @var \cycro\StructType\GeneralShipmentData
     */
    public $generalShipmentData;
    /**
     * The productAndServiceData
     * Meta informations extracted from the WSDL
     * - documentation: Contains special data for a shipment.
     * - minOccurs: 1
     * @var \cycro\StructType\ProductAndServiceData
     */
    public $productAndServiceData;
    /**
     * The parcels
     * Meta informations extracted from the WSDL
     * - documentation: Contains information for the parcels.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cycro\StructType\Parcel[]
     */
    public $parcels;
    /**
     * Constructor method for shipmentServiceData
     * @uses ShipmentServiceData::setGeneralShipmentData()
     * @uses ShipmentServiceData::setProductAndServiceData()
     * @uses ShipmentServiceData::setParcels()
     * @param \cycro\StructType\GeneralShipmentData $generalShipmentData
     * @param \cycro\StructType\ProductAndServiceData $productAndServiceData
     * @param \cycro\StructType\Parcel[] $parcels
     */
    public function __construct(\cycro\StructType\GeneralShipmentData $generalShipmentData = null, \cycro\StructType\ProductAndServiceData $productAndServiceData = null, array $parcels = array())
    {
        $this
            ->setGeneralShipmentData($generalShipmentData)
            ->setProductAndServiceData($productAndServiceData)
            ->setParcels($parcels);
    }
    /**
     * Get generalShipmentData value
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function getGeneralShipmentData()
    {
        return $this->generalShipmentData;
    }
    /**
     * Set generalShipmentData value
     * @param \cycro\StructType\GeneralShipmentData $generalShipmentData
     * @return \cycro\StructType\ShipmentServiceData
     */
    public function setGeneralShipmentData(\cycro\StructType\GeneralShipmentData $generalShipmentData = null)
    {
        $this->generalShipmentData = $generalShipmentData;
        return $this;
    }
    /**
     * Get productAndServiceData value
     * @return \cycro\StructType\ProductAndServiceData
     */
    public function getProductAndServiceData()
    {
        return $this->productAndServiceData;
    }
    /**
     * Set productAndServiceData value
     * @param \cycro\StructType\ProductAndServiceData $productAndServiceData
     * @return \cycro\StructType\ShipmentServiceData
     */
    public function setProductAndServiceData(\cycro\StructType\ProductAndServiceData $productAndServiceData = null)
    {
        $this->productAndServiceData = $productAndServiceData;
        return $this;
    }
    /**
     * Get parcels value
     * @return \cycro\StructType\Parcel[]|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * Set parcels value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\Parcel[] $parcels
     * @return \cycro\StructType\ShipmentServiceData
     */
    public function setParcels(array $parcels = array())
    {
        foreach ($parcels as $shipmentServiceDataParcelsItem) {
            // validation for constraint: itemType
            if (!$shipmentServiceDataParcelsItem instanceof \cycro\StructType\Parcel) {
                throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of \cycro\StructType\Parcel, "%s" given', is_object($shipmentServiceDataParcelsItem) ? get_class($shipmentServiceDataParcelsItem) : gettype($shipmentServiceDataParcelsItem)), __LINE__);
            }
        }
        $this->parcels = $parcels;
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\Parcel $item
     * @return \cycro\StructType\ShipmentServiceData
     */
    public function addToParcels(\cycro\StructType\Parcel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cycro\StructType\Parcel) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of \cycro\StructType\Parcel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\ShipmentServiceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
