<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for proactiveNotification StructType
 * @subpackage Structs
 */
class ProactiveNotification extends AbstractStructBase
{
    /**
     * The channel
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $channel;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Data for proactive notification, e.g. telephone number, email address, etc.The data format for the proactive message types SMS, phone and FAX is as follows:+international country number#phone
     * numberExamples:+49#1725673423+49#01725673423 | Value for the chosen channel, i.e. the phone number or the e-mail address. No required data format for SMS and phone.
     * - maxLength: 50
     * @var string
     */
    public $value;
    /**
     * The rule
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Rule for which events a notification is sent. Each event has a certain value. By adding the different values it is possible to build combinations of events, e.g. notification for pick-up and delivery is 5.The different values are:1 =
     * pick-up2 = non-delivery4 = delivery8 = inbound16 = out for delivery
     * - maxInclusive: 31
     * @var int
     */
    public $rule;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Language of the proactive notification in ISO-3166-1 alpha-2 format (e.g. 'DE'). | Language of the notification in ISO 3166-1 alpha-2 format (e.g. 'DE').
     * - length: 2
     * @var string
     */
    public $language;
    /**
     * Constructor method for proactiveNotification
     * @uses ProactiveNotification::setChannel()
     * @uses ProactiveNotification::setValue()
     * @uses ProactiveNotification::setRule()
     * @uses ProactiveNotification::setLanguage()
     * @param string $channel
     * @param string $value
     * @param int $rule
     * @param string $language
     */
    public function __construct($channel = null, $value = null, $rule = null, $language = null)
    {
        $this
            ->setChannel($channel)
            ->setValue($value)
            ->setRule($rule)
            ->setLanguage($language);
    }
    /**
     * Get channel value
     * @return string
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @uses \cycro\EnumType\Channel::valueIsValid()
     * @uses \cycro\EnumType\Channel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channel
     * @return \cycro\StructType\ProactiveNotification
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\Channel::valueIsValid($channel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $channel, implode(', ', \cycro\EnumType\Channel::getValidValues())), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get value value
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \cycro\StructType\ProactiveNotification
     */
    public function setValue($value = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($value) && strlen($value) > 50) || (is_array($value) && count($value) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($value) ? strlen($value) : count($value)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get rule value
     * @return int
     */
    public function getRule()
    {
        return $this->rule;
    }
    /**
     * Set rule value
     * @param int $rule
     * @return \cycro\StructType\ProactiveNotification
     */
    public function setRule($rule = null)
    {
        // validation for constraint: maxInclusive
        if ($rule > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 31, "%s" given', $rule), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($rule) && !is_numeric($rule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rule)), __LINE__);
        }
        $this->rule = $rule;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \cycro\StructType\ProactiveNotification
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: length
        if ((is_scalar($language) && strlen($language) !== 2) || (is_array($language) && count($language) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\ProactiveNotification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
