<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pickup StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bundles pickup data.
 * @subpackage Structs
 */
class Pickup extends AbstractStructBase
{
    /**
     * The quantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Quantity of pickup parcels. Mandatory for consignment.
     * - maxInclusive: 99999
     * @var int
     */
    public $quantity;
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Pickup date in consignments and collection requests. The collection day for advice customers. The from date for pickup information. Format is YYYYMMDD.It can also be used as pickup date for collection requests, then format is YYMMDD.
     * Mandatory for consignment.
     * - maxInclusive: 99999999
     * @var int
     */
    public $date;
    /**
     * The day
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Allowed delivery days in the week (0 = Sunday, 1 = Monday etc.).Comma separated list of possible delivery days (e.g. "2,3,4,5"). | Pickup day of week for consignments and pickup information. Allowed values are 0..6 (0=Sunday,
     * 1=Monday, etc.). Mandatory for consignment.
     * - maxInclusive: 6
     * - maxLength: 20
     * @var int
     */
    public $day;
    /**
     * The tour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Tour number (between 000 and 999).
     * - maxInclusive: 999
     * @var int
     */
    public $tour;
    /**
     * The fromTime1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: From time 1 for consignments and pickup information. Format is hhmm. Mandatory for consignment.
     * - maxInclusive: 2400
     * @var int
     */
    public $fromTime1;
    /**
     * The toTime1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Until time 1 for consignments and pickup information. Format is hhmm. Mandatory for consignment.
     * - maxInclusive: 2400
     * @var int
     */
    public $toTime1;
    /**
     * The fromTime2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: From time 2 for consignments and pickup information. Format is hhmm.
     * - maxInclusive: 2400
     * @var int
     */
    public $fromTime2;
    /**
     * The toTime2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Until time 2 for consignments and pickup information. Format is hhmm.
     * - maxInclusive: 2400
     * @var int
     */
    public $toTime2;
    /**
     * The extraPickup
     * Meta informations extracted from the WSDL
     * - documentation: True if extra pickup is requested.
     * - minOccurs: 0
     * @var bool
     */
    public $extraPickup;
    /**
     * The collectionRequestAddress
     * Meta informations extracted from the WSDL
     * - documentation: Contains pickup address information for consignments and collection requests. Mandatory for consignment.
     * - minOccurs: 0
     * @var \cycro\StructType\Address
     */
    public $collectionRequestAddress;
    /**
     * Constructor method for pickup
     * @uses Pickup::setQuantity()
     * @uses Pickup::setDate()
     * @uses Pickup::setDay()
     * @uses Pickup::setTour()
     * @uses Pickup::setFromTime1()
     * @uses Pickup::setToTime1()
     * @uses Pickup::setFromTime2()
     * @uses Pickup::setToTime2()
     * @uses Pickup::setExtraPickup()
     * @uses Pickup::setCollectionRequestAddress()
     * @param int $quantity
     * @param int $date
     * @param int $day
     * @param int $tour
     * @param int $fromTime1
     * @param int $toTime1
     * @param int $fromTime2
     * @param int $toTime2
     * @param bool $extraPickup
     * @param \cycro\StructType\Address $collectionRequestAddress
     */
    public function __construct($quantity = null, $date = null, $day = null, $tour = null, $fromTime1 = null, $toTime1 = null, $fromTime2 = null, $toTime2 = null, $extraPickup = null, \cycro\StructType\Address $collectionRequestAddress = null)
    {
        $this
            ->setQuantity($quantity)
            ->setDate($date)
            ->setDay($day)
            ->setTour($tour)
            ->setFromTime1($fromTime1)
            ->setToTime1($toTime1)
            ->setFromTime2($fromTime2)
            ->setToTime2($toTime2)
            ->setExtraPickup($extraPickup)
            ->setCollectionRequestAddress($collectionRequestAddress);
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \cycro\StructType\Pickup
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: maxInclusive
        if ($quantity > 99999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999, "%s" given', $quantity), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get date value
     * @return int
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param int $date
     * @return \cycro\StructType\Pickup
     */
    public function setDate($date = null)
    {
        // validation for constraint: maxInclusive
        if ($date > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999, "%s" given', $date), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($date) && !is_numeric($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get day value
     * @return int
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param int $day
     * @return \cycro\StructType\Pickup
     */
    public function setDay($day = null)
    {
        // validation for constraint: maxInclusive
        if ($day > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 6, "%s" given', $day), __LINE__);
        }
        // validation for constraint: maxLength
        if ((is_scalar($day) && strlen($day) > 20) || (is_array($day) && count($day) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($day) ? strlen($day) : count($day)), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($day) && !is_numeric($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($day)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get tour value
     * @return int|null
     */
    public function getTour()
    {
        return $this->tour;
    }
    /**
     * Set tour value
     * @param int $tour
     * @return \cycro\StructType\Pickup
     */
    public function setTour($tour = null)
    {
        // validation for constraint: maxInclusive
        if ($tour > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999, "%s" given', $tour), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($tour) && !is_numeric($tour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tour)), __LINE__);
        }
        $this->tour = $tour;
        return $this;
    }
    /**
     * Get fromTime1 value
     * @return int|null
     */
    public function getFromTime1()
    {
        return $this->fromTime1;
    }
    /**
     * Set fromTime1 value
     * @param int $fromTime1
     * @return \cycro\StructType\Pickup
     */
    public function setFromTime1($fromTime1 = null)
    {
        // validation for constraint: maxInclusive
        if ($fromTime1 > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2400, "%s" given', $fromTime1), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($fromTime1) && !is_numeric($fromTime1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fromTime1)), __LINE__);
        }
        $this->fromTime1 = $fromTime1;
        return $this;
    }
    /**
     * Get toTime1 value
     * @return int|null
     */
    public function getToTime1()
    {
        return $this->toTime1;
    }
    /**
     * Set toTime1 value
     * @param int $toTime1
     * @return \cycro\StructType\Pickup
     */
    public function setToTime1($toTime1 = null)
    {
        // validation for constraint: maxInclusive
        if ($toTime1 > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2400, "%s" given', $toTime1), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($toTime1) && !is_numeric($toTime1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toTime1)), __LINE__);
        }
        $this->toTime1 = $toTime1;
        return $this;
    }
    /**
     * Get fromTime2 value
     * @return int|null
     */
    public function getFromTime2()
    {
        return $this->fromTime2;
    }
    /**
     * Set fromTime2 value
     * @param int $fromTime2
     * @return \cycro\StructType\Pickup
     */
    public function setFromTime2($fromTime2 = null)
    {
        // validation for constraint: maxInclusive
        if ($fromTime2 > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2400, "%s" given', $fromTime2), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($fromTime2) && !is_numeric($fromTime2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fromTime2)), __LINE__);
        }
        $this->fromTime2 = $fromTime2;
        return $this;
    }
    /**
     * Get toTime2 value
     * @return int|null
     */
    public function getToTime2()
    {
        return $this->toTime2;
    }
    /**
     * Set toTime2 value
     * @param int $toTime2
     * @return \cycro\StructType\Pickup
     */
    public function setToTime2($toTime2 = null)
    {
        // validation for constraint: maxInclusive
        if ($toTime2 > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2400, "%s" given', $toTime2), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($toTime2) && !is_numeric($toTime2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toTime2)), __LINE__);
        }
        $this->toTime2 = $toTime2;
        return $this;
    }
    /**
     * Get extraPickup value
     * @return bool|null
     */
    public function getExtraPickup()
    {
        return $this->extraPickup;
    }
    /**
     * Set extraPickup value
     * @param bool $extraPickup
     * @return \cycro\StructType\Pickup
     */
    public function setExtraPickup($extraPickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($extraPickup) && !is_bool($extraPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($extraPickup)), __LINE__);
        }
        $this->extraPickup = $extraPickup;
        return $this;
    }
    /**
     * Get collectionRequestAddress value
     * @return \cycro\StructType\Address|null
     */
    public function getCollectionRequestAddress()
    {
        return $this->collectionRequestAddress;
    }
    /**
     * Set collectionRequestAddress value
     * @param \cycro\StructType\Address $collectionRequestAddress
     * @return \cycro\StructType\Pickup
     */
    public function setCollectionRequestAddress(\cycro\StructType\Address $collectionRequestAddress = null)
    {
        $this->collectionRequestAddress = $collectionRequestAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\Pickup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
