<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generalShipmentData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bundles general shipment data.
 * @subpackage Structs
 */
class GeneralShipmentData extends AbstractStructBase
{
    /**
     * The sendingDepot
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Sending depot for consignment, ordering depot for collection request, customer's depot for pickup information or creating/sending depot for dangerous goods. 4 alphanumeric places, including leading zeros, e.g. 0163.
     * - length: 4
     * @var string
     */
    public $sendingDepot;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $product;
    /**
     * The mpsId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: The shipment number for consignment data.If ordertype is pickup information, the shipment number is an internal database id,which is necessary for technical support requests at DPD. | The shipment number for consignment data. The
     * shipment number is only accepted if the parcel label number is allocated by customer.It starts with one of "MPS", "EXP" or "B2C", the last eight ciphers are the date in format yyyyMMdd.
     * - length: 25
     * - maxLength: 25
     * @var string
     */
    public $mpsId;
    /**
     * The cUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: User ID of the person who made the entry.
     * - maxLength: 10
     * @var string
     */
    public $cUser;
    /**
     * The mpsCustomerReferenceNumber1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Consignment customer reference number 1 (maximal length 35), also customer reference number for collection request orders (maximal length 50).
     * - maxLength: 50
     * @var string
     */
    public $mpsCustomerReferenceNumber1;
    /**
     * The mpsCustomerReferenceNumber2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Consignment customer reference number 2.
     * - maxLength: 35
     * @var string
     */
    public $mpsCustomerReferenceNumber2;
    /**
     * The mpsCustomerReferenceNumber3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Consignment customer reference number 3.
     * - maxLength: 35
     * @var string
     */
    public $mpsCustomerReferenceNumber3;
    /**
     * The mpsCustomerReferenceNumber4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Consignment customer reference number 4.
     * - maxLength: 35
     * @var string
     */
    public $mpsCustomerReferenceNumber4;
    /**
     * The identificationNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Serves as unique alphanumeric key of the shipment used by customer. Can obtain up to 999 ciphers.
     * - maxLength: 999
     * @var string
     */
    public $identificationNumber;
    /**
     * The mpsCompleteDelivery
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the shipment should be sent as complete delivery. Mandatory for COD. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $mpsCompleteDelivery;
    /**
     * The mpsCompleteDeliveryLabel
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the label for complete delivery is printed for pickup. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $mpsCompleteDeliveryLabel;
    /**
     * The mpsVolume
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Volume per consignment in cm3 (without decimal places).
     * - maxInclusive: 999999999
     * @var int
     */
    public $mpsVolume;
    /**
     * The mpsWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Shipment weight in grams rounded in 10 gram units without decimal separator (e.g. 300 equals 3kg).
     * - maxInclusive: 99999999
     * @var int
     */
    public $mpsWeight;
    /**
     * The mpsExpectedSendingDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Date when the shipment is expected to be transferred to the system. Format is YYYYMMDD.
     * - pattern: [2][0-9]{3}([0][0-9]|[1][0-2])(0[1-9]|[12][0-9]|3[01])
     * @var string
     */
    public $mpsExpectedSendingDate;
    /**
     * The mpsExpectedSendingTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Time when the shipment is expected to be transferred to the system. Format is HHMMSS.
     * - pattern: (([1][0-9]|[2][0-3]|[0][0-9])([0-5][0-9])([0-5][0-9]))|([0-9]([0-5][0-9])([0-5][0-9]))
     * @var string
     */
    public $mpsExpectedSendingTime;
    /**
     * The sender
     * Meta informations extracted from the WSDL
     * - documentation: Consignment sender's address, collection request customer's address or pickup information customer's address.
     * @var \cycro\StructType\Address
     */
    public $sender;
    /**
     * The recipient
     * Meta informations extracted from the WSDL
     * - documentation: Address of the recipient. For parcel shop delivery address of the real recipient.
     * @var \cycro\StructType\Address
     */
    public $recipient;
    /**
     * Constructor method for generalShipmentData
     * @uses GeneralShipmentData::setSendingDepot()
     * @uses GeneralShipmentData::setProduct()
     * @uses GeneralShipmentData::setMpsId()
     * @uses GeneralShipmentData::setCUser()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber1()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber2()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber3()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber4()
     * @uses GeneralShipmentData::setIdentificationNumber()
     * @uses GeneralShipmentData::setMpsCompleteDelivery()
     * @uses GeneralShipmentData::setMpsCompleteDeliveryLabel()
     * @uses GeneralShipmentData::setMpsVolume()
     * @uses GeneralShipmentData::setMpsWeight()
     * @uses GeneralShipmentData::setMpsExpectedSendingDate()
     * @uses GeneralShipmentData::setMpsExpectedSendingTime()
     * @uses GeneralShipmentData::setSender()
     * @uses GeneralShipmentData::setRecipient()
     * @param string $sendingDepot
     * @param string $product
     * @param string $mpsId
     * @param string $cUser
     * @param string $mpsCustomerReferenceNumber1
     * @param string $mpsCustomerReferenceNumber2
     * @param string $mpsCustomerReferenceNumber3
     * @param string $mpsCustomerReferenceNumber4
     * @param string $identificationNumber
     * @param bool $mpsCompleteDelivery
     * @param bool $mpsCompleteDeliveryLabel
     * @param int $mpsVolume
     * @param int $mpsWeight
     * @param string $mpsExpectedSendingDate
     * @param string $mpsExpectedSendingTime
     * @param \cycro\StructType\Address $sender
     * @param \cycro\StructType\Address $recipient
     */
    public function __construct($sendingDepot = null, $product = null, $mpsId = null, $cUser = null, $mpsCustomerReferenceNumber1 = null, $mpsCustomerReferenceNumber2 = null, $mpsCustomerReferenceNumber3 = null, $mpsCustomerReferenceNumber4 = null, $identificationNumber = null, $mpsCompleteDelivery = null, $mpsCompleteDeliveryLabel = null, $mpsVolume = null, $mpsWeight = null, $mpsExpectedSendingDate = null, $mpsExpectedSendingTime = null, \cycro\StructType\Address $sender = null, \cycro\StructType\Address $recipient = null)
    {
        $this
            ->setSendingDepot($sendingDepot)
            ->setProduct($product)
            ->setMpsId($mpsId)
            ->setCUser($cUser)
            ->setMpsCustomerReferenceNumber1($mpsCustomerReferenceNumber1)
            ->setMpsCustomerReferenceNumber2($mpsCustomerReferenceNumber2)
            ->setMpsCustomerReferenceNumber3($mpsCustomerReferenceNumber3)
            ->setMpsCustomerReferenceNumber4($mpsCustomerReferenceNumber4)
            ->setIdentificationNumber($identificationNumber)
            ->setMpsCompleteDelivery($mpsCompleteDelivery)
            ->setMpsCompleteDeliveryLabel($mpsCompleteDeliveryLabel)
            ->setMpsVolume($mpsVolume)
            ->setMpsWeight($mpsWeight)
            ->setMpsExpectedSendingDate($mpsExpectedSendingDate)
            ->setMpsExpectedSendingTime($mpsExpectedSendingTime)
            ->setSender($sender)
            ->setRecipient($recipient);
    }
    /**
     * Get sendingDepot value
     * @return string
     */
    public function getSendingDepot()
    {
        return $this->sendingDepot;
    }
    /**
     * Set sendingDepot value
     * @param string $sendingDepot
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setSendingDepot($sendingDepot = null)
    {
        // validation for constraint: length
        if ((is_scalar($sendingDepot) && strlen($sendingDepot) !== 4) || (is_array($sendingDepot) && count($sendingDepot) !== 4)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendingDepot) && !is_string($sendingDepot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendingDepot)), __LINE__);
        }
        $this->sendingDepot = $sendingDepot;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \cycro\EnumType\Product::valueIsValid()
     * @uses \cycro\EnumType\Product::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\Product::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \cycro\EnumType\Product::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get mpsId value
     * @return string|null
     */
    public function getMpsId()
    {
        return $this->mpsId;
    }
    /**
     * Set mpsId value
     * @param string $mpsId
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setMpsId($mpsId = null)
    {
        // validation for constraint: length
        if ((is_scalar($mpsId) && strlen($mpsId) !== 25) || (is_array($mpsId) && count($mpsId) !== 25)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s)', __LINE__);
        }
        // validation for constraint: maxLength
        if ((is_scalar($mpsId) && strlen($mpsId) > 25) || (is_array($mpsId) && count($mpsId) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($mpsId) ? strlen($mpsId) : count($mpsId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mpsId) && !is_string($mpsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpsId)), __LINE__);
        }
        $this->mpsId = $mpsId;
        return $this;
    }
    /**
     * Get cUser value
     * @return string|null
     */
    public function getCUser()
    {
        return $this->cUser;
    }
    /**
     * Set cUser value
     * @param string $cUser
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setCUser($cUser = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cUser) && strlen($cUser) > 10) || (is_array($cUser) && count($cUser) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($cUser) ? strlen($cUser) : count($cUser)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cUser) && !is_string($cUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUser)), __LINE__);
        }
        $this->cUser = $cUser;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber1 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber1()
    {
        return $this->mpsCustomerReferenceNumber1;
    }
    /**
     * Set mpsCustomerReferenceNumber1 value
     * @param string $mpsCustomerReferenceNumber1
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber1($mpsCustomerReferenceNumber1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mpsCustomerReferenceNumber1) && strlen($mpsCustomerReferenceNumber1) > 50) || (is_array($mpsCustomerReferenceNumber1) && count($mpsCustomerReferenceNumber1) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($mpsCustomerReferenceNumber1) ? strlen($mpsCustomerReferenceNumber1) : count($mpsCustomerReferenceNumber1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber1) && !is_string($mpsCustomerReferenceNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpsCustomerReferenceNumber1)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber1 = $mpsCustomerReferenceNumber1;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber2 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber2()
    {
        return $this->mpsCustomerReferenceNumber2;
    }
    /**
     * Set mpsCustomerReferenceNumber2 value
     * @param string $mpsCustomerReferenceNumber2
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber2($mpsCustomerReferenceNumber2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mpsCustomerReferenceNumber2) && strlen($mpsCustomerReferenceNumber2) > 35) || (is_array($mpsCustomerReferenceNumber2) && count($mpsCustomerReferenceNumber2) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($mpsCustomerReferenceNumber2) ? strlen($mpsCustomerReferenceNumber2) : count($mpsCustomerReferenceNumber2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber2) && !is_string($mpsCustomerReferenceNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpsCustomerReferenceNumber2)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber2 = $mpsCustomerReferenceNumber2;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber3 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber3()
    {
        return $this->mpsCustomerReferenceNumber3;
    }
    /**
     * Set mpsCustomerReferenceNumber3 value
     * @param string $mpsCustomerReferenceNumber3
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber3($mpsCustomerReferenceNumber3 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mpsCustomerReferenceNumber3) && strlen($mpsCustomerReferenceNumber3) > 35) || (is_array($mpsCustomerReferenceNumber3) && count($mpsCustomerReferenceNumber3) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($mpsCustomerReferenceNumber3) ? strlen($mpsCustomerReferenceNumber3) : count($mpsCustomerReferenceNumber3)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber3) && !is_string($mpsCustomerReferenceNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpsCustomerReferenceNumber3)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber3 = $mpsCustomerReferenceNumber3;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber4 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber4()
    {
        return $this->mpsCustomerReferenceNumber4;
    }
    /**
     * Set mpsCustomerReferenceNumber4 value
     * @param string $mpsCustomerReferenceNumber4
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber4($mpsCustomerReferenceNumber4 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mpsCustomerReferenceNumber4) && strlen($mpsCustomerReferenceNumber4) > 35) || (is_array($mpsCustomerReferenceNumber4) && count($mpsCustomerReferenceNumber4) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($mpsCustomerReferenceNumber4) ? strlen($mpsCustomerReferenceNumber4) : count($mpsCustomerReferenceNumber4)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber4) && !is_string($mpsCustomerReferenceNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpsCustomerReferenceNumber4)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber4 = $mpsCustomerReferenceNumber4;
        return $this;
    }
    /**
     * Get identificationNumber value
     * @return string|null
     */
    public function getIdentificationNumber()
    {
        return $this->identificationNumber;
    }
    /**
     * Set identificationNumber value
     * @param string $identificationNumber
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setIdentificationNumber($identificationNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificationNumber) && strlen($identificationNumber) > 999) || (is_array($identificationNumber) && count($identificationNumber) > 999)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 999 element(s) or a scalar of 999 character(s) at most, "%d" length given', is_scalar($identificationNumber) ? strlen($identificationNumber) : count($identificationNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificationNumber) && !is_string($identificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificationNumber)), __LINE__);
        }
        $this->identificationNumber = $identificationNumber;
        return $this;
    }
    /**
     * Get mpsCompleteDelivery value
     * @return bool|null
     */
    public function getMpsCompleteDelivery()
    {
        return $this->mpsCompleteDelivery;
    }
    /**
     * Set mpsCompleteDelivery value
     * @param bool $mpsCompleteDelivery
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setMpsCompleteDelivery($mpsCompleteDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($mpsCompleteDelivery) && !is_bool($mpsCompleteDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mpsCompleteDelivery)), __LINE__);
        }
        $this->mpsCompleteDelivery = $mpsCompleteDelivery;
        return $this;
    }
    /**
     * Get mpsCompleteDeliveryLabel value
     * @return bool|null
     */
    public function getMpsCompleteDeliveryLabel()
    {
        return $this->mpsCompleteDeliveryLabel;
    }
    /**
     * Set mpsCompleteDeliveryLabel value
     * @param bool $mpsCompleteDeliveryLabel
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setMpsCompleteDeliveryLabel($mpsCompleteDeliveryLabel = null)
    {
        // validation for constraint: boolean
        if (!is_null($mpsCompleteDeliveryLabel) && !is_bool($mpsCompleteDeliveryLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mpsCompleteDeliveryLabel)), __LINE__);
        }
        $this->mpsCompleteDeliveryLabel = $mpsCompleteDeliveryLabel;
        return $this;
    }
    /**
     * Get mpsVolume value
     * @return int|null
     */
    public function getMpsVolume()
    {
        return $this->mpsVolume;
    }
    /**
     * Set mpsVolume value
     * @param int $mpsVolume
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setMpsVolume($mpsVolume = null)
    {
        // validation for constraint: maxInclusive
        if ($mpsVolume > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $mpsVolume), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($mpsVolume) && !is_numeric($mpsVolume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mpsVolume)), __LINE__);
        }
        $this->mpsVolume = $mpsVolume;
        return $this;
    }
    /**
     * Get mpsWeight value
     * @return int|null
     */
    public function getMpsWeight()
    {
        return $this->mpsWeight;
    }
    /**
     * Set mpsWeight value
     * @param int $mpsWeight
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setMpsWeight($mpsWeight = null)
    {
        // validation for constraint: maxInclusive
        if ($mpsWeight > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999, "%s" given', $mpsWeight), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($mpsWeight) && !is_numeric($mpsWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mpsWeight)), __LINE__);
        }
        $this->mpsWeight = $mpsWeight;
        return $this;
    }
    /**
     * Get mpsExpectedSendingDate value
     * @return string|null
     */
    public function getMpsExpectedSendingDate()
    {
        return $this->mpsExpectedSendingDate;
    }
    /**
     * Set mpsExpectedSendingDate value
     * @param string $mpsExpectedSendingDate
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setMpsExpectedSendingDate($mpsExpectedSendingDate = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mpsExpectedSendingDate) && !preg_match('/[2][0-9]{3}([0][0-9]|[1][0-2])(0[1-9]|[12][0-9]|3[01])/', $mpsExpectedSendingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[2][0-9]{3}([0][0-9]|[1][0-2])(0[1-9]|[12][0-9]|3[01])", "%s" given', var_export($mpsExpectedSendingDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mpsExpectedSendingDate) && !is_string($mpsExpectedSendingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpsExpectedSendingDate)), __LINE__);
        }
        $this->mpsExpectedSendingDate = $mpsExpectedSendingDate;
        return $this;
    }
    /**
     * Get mpsExpectedSendingTime value
     * @return string|null
     */
    public function getMpsExpectedSendingTime()
    {
        return $this->mpsExpectedSendingTime;
    }
    /**
     * Set mpsExpectedSendingTime value
     * @param string $mpsExpectedSendingTime
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setMpsExpectedSendingTime($mpsExpectedSendingTime = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mpsExpectedSendingTime) && !preg_match('/(([1][0-9]|[2][0-3]|[0][0-9])([0-5][0-9])([0-5][0-9]))|([0-9]([0-5][0-9])([0-5][0-9]))/', $mpsExpectedSendingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([1][0-9]|[2][0-3]|[0][0-9])([0-5][0-9])([0-5][0-9]))|([0-9]([0-5][0-9])([0-5][0-9]))", "%s" given', var_export($mpsExpectedSendingTime, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mpsExpectedSendingTime) && !is_string($mpsExpectedSendingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpsExpectedSendingTime)), __LINE__);
        }
        $this->mpsExpectedSendingTime = $mpsExpectedSendingTime;
        return $this;
    }
    /**
     * Get sender value
     * @return \cycro\StructType\Address|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param \cycro\StructType\Address $sender
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setSender(\cycro\StructType\Address $sender = null)
    {
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get recipient value
     * @return \cycro\StructType\Address|null
     */
    public function getRecipient()
    {
        return $this->recipient;
    }
    /**
     * Set recipient value
     * @param \cycro\StructType\Address $recipient
     * @return \cycro\StructType\GeneralShipmentData
     */
    public function setRecipient(\cycro\StructType\Address $recipient = null)
    {
        $this->recipient = $recipient;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\GeneralShipmentData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
