<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authentication StructType
 * Meta informations extracted from the WSDL
 * - documentation: The data structure for authentication data. | The data structure for authentication data.
 * @subpackage Structs
 */
class Authentication extends AbstractStructBase
{
    /**
     * The delisId
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: The delis user id for authentication.
     * - maxLength: 10
     * - minLength: 8
     * @var string
     */
    public $delisId;
    /**
     * The authToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: The token for authentication. Field authToken of Login, as a result ofMethod "getAuth" of LoginService.
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $authToken;
    /**
     * The messageLanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: The language (Java format) for messages."de_DE" for german messages."en_US" for english messages.
     * - maxLength: 5
     * - minLength: 5
     * @var string
     */
    public $messageLanguage;
    /**
     * Constructor method for authentication
     * @uses Authentication::setDelisId()
     * @uses Authentication::setAuthToken()
     * @uses Authentication::setMessageLanguage()
     * @param string $delisId
     * @param string $authToken
     * @param string $messageLanguage
     */
    public function __construct($delisId = null, $authToken = null, $messageLanguage = null)
    {
        $this
            ->setDelisId($delisId)
            ->setAuthToken($authToken)
            ->setMessageLanguage($messageLanguage);
    }
    /**
     * Get delisId value
     * @return string
     */
    public function getDelisId()
    {
        return $this->delisId;
    }
    /**
     * Set delisId value
     * @param string $delisId
     * @return \cycro\StructType\Authentication
     */
    public function setDelisId($delisId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($delisId) && strlen($delisId) > 10) || (is_array($delisId) && count($delisId) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($delisId) ? strlen($delisId) : count($delisId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($delisId) && strlen($delisId) < 8) || (is_array($delisId) && count($delisId) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($delisId) && !is_string($delisId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delisId)), __LINE__);
        }
        $this->delisId = $delisId;
        return $this;
    }
    /**
     * Get authToken value
     * @return string
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \cycro\StructType\Authentication
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authToken) && strlen($authToken) > 64) || (is_array($authToken) && count($authToken) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($authToken) ? strlen($authToken) : count($authToken)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authToken) && strlen($authToken) < 0) || (is_array($authToken) && count($authToken) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get messageLanguage value
     * @return string
     */
    public function getMessageLanguage()
    {
        return $this->messageLanguage;
    }
    /**
     * Set messageLanguage value
     * @param string $messageLanguage
     * @return \cycro\StructType\Authentication
     */
    public function setMessageLanguage($messageLanguage = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageLanguage) && strlen($messageLanguage) > 5) || (is_array($messageLanguage) && count($messageLanguage) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($messageLanguage) ? strlen($messageLanguage) : count($messageLanguage)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageLanguage) && strlen($messageLanguage) < 5) || (is_array($messageLanguage) && count($messageLanguage) < 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageLanguage) && !is_string($messageLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageLanguage)), __LINE__);
        }
        $this->messageLanguage = $messageLanguage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\Authentication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
