<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcel StructType
 * @subpackage Structs
 */
class Parcel extends AbstractStructBase
{
    /**
     * The parcelLabelNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Parcel label number. Number range and validity are checked. Length can be 11 or 14.
     * - maxLength: 14
     * - minLength: 11
     * @var string
     */
    public $parcelLabelNumber;
    /**
     * The customerReferenceNumber1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Parcel customer reference number 1.
     * - maxLength: 35
     * @var string
     */
    public $customerReferenceNumber1;
    /**
     * The customerReferenceNumber2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Parcel customer reference number 2.
     * - maxLength: 35
     * @var string
     */
    public $customerReferenceNumber2;
    /**
     * The customerReferenceNumber3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Parcel customer reference number 3.
     * - maxLength: 35
     * @var string
     */
    public $customerReferenceNumber3;
    /**
     * The customerReferenceNumber4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Parcel customer reference number 4.
     * - maxLength: 35
     * @var string
     */
    public $customerReferenceNumber4;
    /**
     * The swap
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the parcel is a consignment swap parcel. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $swap;
    /**
     * The volume
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Volume of the single parcel (length/width/height in format LLLWWWHHH) in cm without separators.
     * - maxInclusive: 999999999
     * @var int
     */
    public $volume;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Parcel weight in grams rounded in 10 gram units without decimal delimiter (e.g. 300 equals 3kg). Consignement allows 8-digit values, collection requests 7-digit and dangerous goods 6-digit.
     * - maxInclusive: 99999999
     * @var int
     */
    public $weight;
    /**
     * The hazardousLimitedQuantities
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the parcel is a limited quantities hazardous goods parcel. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $hazardousLimitedQuantities;
    /**
     * The higherInsurance
     * Meta informations extracted from the WSDL
     * - documentation: Defines if the parcel has increased insurance value. Default value is false.
     * - minOccurs: 0
     * @var \cycro\StructType\HigherInsurance
     */
    public $higherInsurance;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Content of the parcel. Mandatory for increased insurance. For collection requests maximum length is 50, for consignment it is 35.
     * - maxLength: 50
     * @var string
     */
    public $content;
    /**
     * The addService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addService;
    /**
     * The messageNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Message number for consignment shipper information. Default value is 1.
     * - maxInclusive: 99999
     * @var int
     */
    public $messageNumber;
    /**
     * The function
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $function;
    /**
     * The parameter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Free text for blockable functions.
     * - maxLength: 300
     * @var string
     */
    public $parameter;
    /**
     * The cod
     * Meta informations extracted from the WSDL
     * - documentation: Contains COD data for COD consignments.
     * - minOccurs: 0
     * @var \cycro\StructType\Cod
     */
    public $cod;
    /**
     * The international
     * Meta informations extracted from the WSDL
     * - documentation: Contains data for consignments across customs frontiers.
     * - minOccurs: 0
     * @var \cycro\StructType\International
     */
    public $international;
    /**
     * The hazardous
     * Meta informations extracted from the WSDL
     * - documentation: Contains packing and substance data for dangerous goods.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \cycro\StructType\Hazardous[]
     */
    public $hazardous;
    /**
     * The printInfo1OnParcelLabel
     * Meta informations extracted from the WSDL
     * - documentation: Determines if content of parameter info1 will be added on the label of a collection request parcel. Default value is false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $printInfo1OnParcelLabel;
    /**
     * The info1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Information text 1. Will be printed on the parcel label if the flag printInfo1OnParcellabel is set to true.
     * - maxLength: 29
     * @var string
     */
    public $info1;
    /**
     * The info2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Information text 2. Will not be printed on the parcel label.
     * - maxLength: 30
     * @var string
     */
    public $info2;
    /**
     * The returns
     * Meta informations extracted from the WSDL
     * - documentation: Defines if parcel is a return parcel. The return parcel must always be next in order to the corresponding outbound parcel. Default value is false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $returns;
    /**
     * Constructor method for parcel
     * @uses Parcel::setParcelLabelNumber()
     * @uses Parcel::setCustomerReferenceNumber1()
     * @uses Parcel::setCustomerReferenceNumber2()
     * @uses Parcel::setCustomerReferenceNumber3()
     * @uses Parcel::setCustomerReferenceNumber4()
     * @uses Parcel::setSwap()
     * @uses Parcel::setVolume()
     * @uses Parcel::setWeight()
     * @uses Parcel::setHazardousLimitedQuantities()
     * @uses Parcel::setHigherInsurance()
     * @uses Parcel::setContent()
     * @uses Parcel::setAddService()
     * @uses Parcel::setMessageNumber()
     * @uses Parcel::setFunction()
     * @uses Parcel::setParameter()
     * @uses Parcel::setCod()
     * @uses Parcel::setInternational()
     * @uses Parcel::setHazardous()
     * @uses Parcel::setPrintInfo1OnParcelLabel()
     * @uses Parcel::setInfo1()
     * @uses Parcel::setInfo2()
     * @uses Parcel::setReturns()
     * @param string $parcelLabelNumber
     * @param string $customerReferenceNumber1
     * @param string $customerReferenceNumber2
     * @param string $customerReferenceNumber3
     * @param string $customerReferenceNumber4
     * @param bool $swap
     * @param int $volume
     * @param int $weight
     * @param bool $hazardousLimitedQuantities
     * @param \cycro\StructType\HigherInsurance $higherInsurance
     * @param string $content
     * @param string $addService
     * @param int $messageNumber
     * @param string $function
     * @param string $parameter
     * @param \cycro\StructType\Cod $cod
     * @param \cycro\StructType\International $international
     * @param \cycro\StructType\Hazardous[] $hazardous
     * @param bool $printInfo1OnParcelLabel
     * @param string $info1
     * @param string $info2
     * @param bool $returns
     */
    public function __construct($parcelLabelNumber = null, $customerReferenceNumber1 = null, $customerReferenceNumber2 = null, $customerReferenceNumber3 = null, $customerReferenceNumber4 = null, $swap = null, $volume = null, $weight = null, $hazardousLimitedQuantities = null, \cycro\StructType\HigherInsurance $higherInsurance = null, $content = null, $addService = null, $messageNumber = null, $function = null, $parameter = null, \cycro\StructType\Cod $cod = null, \cycro\StructType\International $international = null, array $hazardous = array(), $printInfo1OnParcelLabel = null, $info1 = null, $info2 = null, $returns = null)
    {
        $this
            ->setParcelLabelNumber($parcelLabelNumber)
            ->setCustomerReferenceNumber1($customerReferenceNumber1)
            ->setCustomerReferenceNumber2($customerReferenceNumber2)
            ->setCustomerReferenceNumber3($customerReferenceNumber3)
            ->setCustomerReferenceNumber4($customerReferenceNumber4)
            ->setSwap($swap)
            ->setVolume($volume)
            ->setWeight($weight)
            ->setHazardousLimitedQuantities($hazardousLimitedQuantities)
            ->setHigherInsurance($higherInsurance)
            ->setContent($content)
            ->setAddService($addService)
            ->setMessageNumber($messageNumber)
            ->setFunction($function)
            ->setParameter($parameter)
            ->setCod($cod)
            ->setInternational($international)
            ->setHazardous($hazardous)
            ->setPrintInfo1OnParcelLabel($printInfo1OnParcelLabel)
            ->setInfo1($info1)
            ->setInfo2($info2)
            ->setReturns($returns);
    }
    /**
     * Get parcelLabelNumber value
     * @return string|null
     */
    public function getParcelLabelNumber()
    {
        return $this->parcelLabelNumber;
    }
    /**
     * Set parcelLabelNumber value
     * @param string $parcelLabelNumber
     * @return \cycro\StructType\Parcel
     */
    public function setParcelLabelNumber($parcelLabelNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($parcelLabelNumber) && strlen($parcelLabelNumber) > 14) || (is_array($parcelLabelNumber) && count($parcelLabelNumber) > 14)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 14 element(s) or a scalar of 14 character(s) at most, "%d" length given', is_scalar($parcelLabelNumber) ? strlen($parcelLabelNumber) : count($parcelLabelNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($parcelLabelNumber) && strlen($parcelLabelNumber) < 11) || (is_array($parcelLabelNumber) && count($parcelLabelNumber) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parcelLabelNumber) && !is_string($parcelLabelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parcelLabelNumber)), __LINE__);
        }
        $this->parcelLabelNumber = $parcelLabelNumber;
        return $this;
    }
    /**
     * Get customerReferenceNumber1 value
     * @return string|null
     */
    public function getCustomerReferenceNumber1()
    {
        return $this->customerReferenceNumber1;
    }
    /**
     * Set customerReferenceNumber1 value
     * @param string $customerReferenceNumber1
     * @return \cycro\StructType\Parcel
     */
    public function setCustomerReferenceNumber1($customerReferenceNumber1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customerReferenceNumber1) && strlen($customerReferenceNumber1) > 35) || (is_array($customerReferenceNumber1) && count($customerReferenceNumber1) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($customerReferenceNumber1) ? strlen($customerReferenceNumber1) : count($customerReferenceNumber1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customerReferenceNumber1) && !is_string($customerReferenceNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerReferenceNumber1)), __LINE__);
        }
        $this->customerReferenceNumber1 = $customerReferenceNumber1;
        return $this;
    }
    /**
     * Get customerReferenceNumber2 value
     * @return string|null
     */
    public function getCustomerReferenceNumber2()
    {
        return $this->customerReferenceNumber2;
    }
    /**
     * Set customerReferenceNumber2 value
     * @param string $customerReferenceNumber2
     * @return \cycro\StructType\Parcel
     */
    public function setCustomerReferenceNumber2($customerReferenceNumber2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customerReferenceNumber2) && strlen($customerReferenceNumber2) > 35) || (is_array($customerReferenceNumber2) && count($customerReferenceNumber2) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($customerReferenceNumber2) ? strlen($customerReferenceNumber2) : count($customerReferenceNumber2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customerReferenceNumber2) && !is_string($customerReferenceNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerReferenceNumber2)), __LINE__);
        }
        $this->customerReferenceNumber2 = $customerReferenceNumber2;
        return $this;
    }
    /**
     * Get customerReferenceNumber3 value
     * @return string|null
     */
    public function getCustomerReferenceNumber3()
    {
        return $this->customerReferenceNumber3;
    }
    /**
     * Set customerReferenceNumber3 value
     * @param string $customerReferenceNumber3
     * @return \cycro\StructType\Parcel
     */
    public function setCustomerReferenceNumber3($customerReferenceNumber3 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customerReferenceNumber3) && strlen($customerReferenceNumber3) > 35) || (is_array($customerReferenceNumber3) && count($customerReferenceNumber3) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($customerReferenceNumber3) ? strlen($customerReferenceNumber3) : count($customerReferenceNumber3)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customerReferenceNumber3) && !is_string($customerReferenceNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerReferenceNumber3)), __LINE__);
        }
        $this->customerReferenceNumber3 = $customerReferenceNumber3;
        return $this;
    }
    /**
     * Get customerReferenceNumber4 value
     * @return string|null
     */
    public function getCustomerReferenceNumber4()
    {
        return $this->customerReferenceNumber4;
    }
    /**
     * Set customerReferenceNumber4 value
     * @param string $customerReferenceNumber4
     * @return \cycro\StructType\Parcel
     */
    public function setCustomerReferenceNumber4($customerReferenceNumber4 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customerReferenceNumber4) && strlen($customerReferenceNumber4) > 35) || (is_array($customerReferenceNumber4) && count($customerReferenceNumber4) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($customerReferenceNumber4) ? strlen($customerReferenceNumber4) : count($customerReferenceNumber4)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customerReferenceNumber4) && !is_string($customerReferenceNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerReferenceNumber4)), __LINE__);
        }
        $this->customerReferenceNumber4 = $customerReferenceNumber4;
        return $this;
    }
    /**
     * Get swap value
     * @return bool|null
     */
    public function getSwap()
    {
        return $this->swap;
    }
    /**
     * Set swap value
     * @param bool $swap
     * @return \cycro\StructType\Parcel
     */
    public function setSwap($swap = null)
    {
        // validation for constraint: boolean
        if (!is_null($swap) && !is_bool($swap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($swap)), __LINE__);
        }
        $this->swap = $swap;
        return $this;
    }
    /**
     * Get volume value
     * @return int|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param int $volume
     * @return \cycro\StructType\Parcel
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: maxInclusive
        if ($volume > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $volume), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($volume) && !is_numeric($volume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($volume)), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param int $weight
     * @return \cycro\StructType\Parcel
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: maxInclusive
        if ($weight > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999, "%s" given', $weight), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($weight) && !is_numeric($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get hazardousLimitedQuantities value
     * @return bool|null
     */
    public function getHazardousLimitedQuantities()
    {
        return $this->hazardousLimitedQuantities;
    }
    /**
     * Set hazardousLimitedQuantities value
     * @param bool $hazardousLimitedQuantities
     * @return \cycro\StructType\Parcel
     */
    public function setHazardousLimitedQuantities($hazardousLimitedQuantities = null)
    {
        // validation for constraint: boolean
        if (!is_null($hazardousLimitedQuantities) && !is_bool($hazardousLimitedQuantities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hazardousLimitedQuantities)), __LINE__);
        }
        $this->hazardousLimitedQuantities = $hazardousLimitedQuantities;
        return $this;
    }
    /**
     * Get higherInsurance value
     * @return \cycro\StructType\HigherInsurance|null
     */
    public function getHigherInsurance()
    {
        return $this->higherInsurance;
    }
    /**
     * Set higherInsurance value
     * @param \cycro\StructType\HigherInsurance $higherInsurance
     * @return \cycro\StructType\Parcel
     */
    public function setHigherInsurance(\cycro\StructType\HigherInsurance $higherInsurance = null)
    {
        $this->higherInsurance = $higherInsurance;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \cycro\StructType\Parcel
     */
    public function setContent($content = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($content) && strlen($content) > 50) || (is_array($content) && count($content) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($content) ? strlen($content) : count($content)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get addService value
     * @return string|null
     */
    public function getAddService()
    {
        return $this->addService;
    }
    /**
     * Set addService value
     * @uses \cycro\EnumType\AddService::valueIsValid()
     * @uses \cycro\EnumType\AddService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addService
     * @return \cycro\StructType\Parcel
     */
    public function setAddService($addService = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\AddService::valueIsValid($addService)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $addService, implode(', ', \cycro\EnumType\AddService::getValidValues())), __LINE__);
        }
        $this->addService = $addService;
        return $this;
    }
    /**
     * Get messageNumber value
     * @return int|null
     */
    public function getMessageNumber()
    {
        return $this->messageNumber;
    }
    /**
     * Set messageNumber value
     * @param int $messageNumber
     * @return \cycro\StructType\Parcel
     */
    public function setMessageNumber($messageNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($messageNumber > 99999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999, "%s" given', $messageNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($messageNumber) && !is_numeric($messageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($messageNumber)), __LINE__);
        }
        $this->messageNumber = $messageNumber;
        return $this;
    }
    /**
     * Get function value
     * @return string|null
     */
    public function getFunction()
    {
        return $this->function;
    }
    /**
     * Set function value
     * @uses \cycro\EnumType\_function::valueIsValid()
     * @uses \cycro\EnumType\_function::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $function
     * @return \cycro\StructType\Parcel
     */
    public function setFunction($function = null)
    {
        // validation for constraint: enumeration
        if (!\cycro\EnumType\_function::valueIsValid($function)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $function, implode(', ', \cycro\EnumType\_function::getValidValues())), __LINE__);
        }
        $this->function = $function;
        return $this;
    }
    /**
     * Get parameter value
     * @return string|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @param string $parameter
     * @return \cycro\StructType\Parcel
     */
    public function setParameter($parameter = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($parameter) && strlen($parameter) > 300) || (is_array($parameter) && count($parameter) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($parameter) ? strlen($parameter) : count($parameter)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parameter) && !is_string($parameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parameter)), __LINE__);
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Get cod value
     * @return \cycro\StructType\Cod|null
     */
    public function getCod()
    {
        return $this->cod;
    }
    /**
     * Set cod value
     * @param \cycro\StructType\Cod $cod
     * @return \cycro\StructType\Parcel
     */
    public function setCod(\cycro\StructType\Cod $cod = null)
    {
        $this->cod = $cod;
        return $this;
    }
    /**
     * Get international value
     * @return \cycro\StructType\International|null
     */
    public function getInternational()
    {
        return $this->international;
    }
    /**
     * Set international value
     * @param \cycro\StructType\International $international
     * @return \cycro\StructType\Parcel
     */
    public function setInternational(\cycro\StructType\International $international = null)
    {
        $this->international = $international;
        return $this;
    }
    /**
     * Get hazardous value
     * @return \cycro\StructType\Hazardous[]|null
     */
    public function getHazardous()
    {
        return $this->hazardous;
    }
    /**
     * Set hazardous value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\Hazardous[] $hazardous
     * @return \cycro\StructType\Parcel
     */
    public function setHazardous(array $hazardous = array())
    {
        foreach ($hazardous as $parcelHazardousItem) {
            // validation for constraint: itemType
            if (!$parcelHazardousItem instanceof \cycro\StructType\Hazardous) {
                throw new \InvalidArgumentException(sprintf('The hazardous property can only contain items of \cycro\StructType\Hazardous, "%s" given', is_object($parcelHazardousItem) ? get_class($parcelHazardousItem) : gettype($parcelHazardousItem)), __LINE__);
            }
        }
        $this->hazardous = $hazardous;
        return $this;
    }
    /**
     * Add item to hazardous value
     * @throws \InvalidArgumentException
     * @param \cycro\StructType\Hazardous $item
     * @return \cycro\StructType\Parcel
     */
    public function addToHazardous(\cycro\StructType\Hazardous $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cycro\StructType\Hazardous) {
            throw new \InvalidArgumentException(sprintf('The hazardous property can only contain items of \cycro\StructType\Hazardous, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->hazardous[] = $item;
        return $this;
    }
    /**
     * Get printInfo1OnParcelLabel value
     * @return bool|null
     */
    public function getPrintInfo1OnParcelLabel()
    {
        return $this->printInfo1OnParcelLabel;
    }
    /**
     * Set printInfo1OnParcelLabel value
     * @param bool $printInfo1OnParcelLabel
     * @return \cycro\StructType\Parcel
     */
    public function setPrintInfo1OnParcelLabel($printInfo1OnParcelLabel = null)
    {
        // validation for constraint: boolean
        if (!is_null($printInfo1OnParcelLabel) && !is_bool($printInfo1OnParcelLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($printInfo1OnParcelLabel)), __LINE__);
        }
        $this->printInfo1OnParcelLabel = $printInfo1OnParcelLabel;
        return $this;
    }
    /**
     * Get info1 value
     * @return string|null
     */
    public function getInfo1()
    {
        return $this->info1;
    }
    /**
     * Set info1 value
     * @param string $info1
     * @return \cycro\StructType\Parcel
     */
    public function setInfo1($info1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($info1) && strlen($info1) > 29) || (is_array($info1) && count($info1) > 29)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 29 element(s) or a scalar of 29 character(s) at most, "%d" length given', is_scalar($info1) ? strlen($info1) : count($info1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($info1) && !is_string($info1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info1)), __LINE__);
        }
        $this->info1 = $info1;
        return $this;
    }
    /**
     * Get info2 value
     * @return string|null
     */
    public function getInfo2()
    {
        return $this->info2;
    }
    /**
     * Set info2 value
     * @param string $info2
     * @return \cycro\StructType\Parcel
     */
    public function setInfo2($info2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($info2) && strlen($info2) > 30) || (is_array($info2) && count($info2) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($info2) ? strlen($info2) : count($info2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($info2) && !is_string($info2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info2)), __LINE__);
        }
        $this->info2 = $info2;
        return $this;
    }
    /**
     * Get returns value
     * @return bool|null
     */
    public function getReturns()
    {
        return $this->returns;
    }
    /**
     * Set returns value
     * @param bool $returns
     * @return \cycro\StructType\Parcel
     */
    public function setReturns($returns = null)
    {
        // validation for constraint: boolean
        if (!is_null($returns) && !is_bool($returns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returns)), __LINE__);
        }
        $this->returns = $returns;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\Parcel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
