<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for higherInsurance StructType
 * @subpackage Structs
 */
class HigherInsurance extends AbstractStructBase
{
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: COD amount in the currency of the destination country. The amount is specified as integer value e.g. 300.00 becomes 30000.Please note the national ceilings for cod in the corresponding relations. | Increased insurance value with 2
     * decimal point positions without separators.
     * - maxInclusive: 9999999999
     * @var int
     */
    public $amount;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: ISO 4217 alpha-3 currency code (destination country). | Currency code for increased insurance in format ISO 4217 alpha 3.
     * - length: 3
     * @var string
     */
    public $currency;
    /**
     * Constructor method for higherInsurance
     * @uses HigherInsurance::setAmount()
     * @uses HigherInsurance::setCurrency()
     * @param int $amount
     * @param string $currency
     */
    public function __construct($amount = null, $currency = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency($currency);
    }
    /**
     * Get amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \cycro\StructType\HigherInsurance
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: maxInclusive
        if ($amount > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999999999, "%s" given', $amount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($amount) && !is_numeric($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \cycro\StructType\HigherInsurance
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: length
        if ((is_scalar($currency) && strlen($currency) !== 3) || (is_array($currency) && count($currency) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\HigherInsurance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
