<?php

namespace cycro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The name1
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Name of address owner. For dangerous goods the maximum length is 50, otherwise always 35.
     * - maxLength: 50
     * @var string
     */
    public $name1;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Street of address owner. For dangerous goods the maximum length is 50, otherwise always 35.
     * - maxLength: 50
     * @var string
     */
    public $street;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Country of address owner in ISO 3166-1 alpha-2 format (e.g. 'DE').
     * - length: 2
     * @var string
     */
    public $country;
    /**
     * The zipCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: Zip code of address owner.
     * - maxLength: 9
     * @var string
     */
    public $zipCode;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - documentation: City/town of address owner. For dangerous goods the maximum length is 50, otherwise always 35.
     * - maxLength: 50
     * @var string
     */
    public $city;
    /**
     * The name2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Name 2 of address owner.
     * - maxLength: 35
     * @var string
     */
    public $name2;
    /**
     * The houseNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: House number of address owner. Maximum length is 8.
     * - maxLength: 8
     * @var string
     */
    public $houseNo;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: State of address owner in ISO 3166-2 code (e.g. BY = Bayern).
     * - length: 2
     * @var string
     */
    public $state;
    /**
     * The gln
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: International location number of address owner.
     * - maxInclusive: 9999999999999
     * @var int
     */
    public $gln;
    /**
     * The customerNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Customer number of address owner. Maximum length is 17 for consignment and pickup information, 11 for collection request. Mandatory for sender's address.
     * - maxLength: 17
     * @var string
     */
    public $customerNumber;
    /**
     * The contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Contact person of address owner.
     * - maxLength: 35
     * @var string
     */
    public $contact;
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Phone number of address owner. Mandatory if phone is the chosen notification channel. No required data format. | Telephone number of the person authorised to accept the consignment. This field is only used for delivery with ID-Check
     * (types 2 and 4). No required data format.
     * - maxLength: 20
     * @var string
     */
    public $phone;
    /**
     * The fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Fax number of address owner. No required data format.
     * - maxLength: 30
     * @var string
     */
    public $fax;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Email address of address owner. For collection requests the maximum length is 40, otherwise always 50.
     * - maxLength: 50
     * @var string
     */
    public $email;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Comment on address owner.
     * - maxLength: 70
     * @var string
     */
    public $comment;
    /**
     * The iaccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Account allocation or cost center (for VTG) of invoice data for consignments.
     * - maxLength: 50
     * @var string
     */
    public $iaccount;
    /**
     * Constructor method for address
     * @uses Address::setName1()
     * @uses Address::setStreet()
     * @uses Address::setCountry()
     * @uses Address::setZipCode()
     * @uses Address::setCity()
     * @uses Address::setName2()
     * @uses Address::setHouseNo()
     * @uses Address::setState()
     * @uses Address::setGln()
     * @uses Address::setCustomerNumber()
     * @uses Address::setContact()
     * @uses Address::setPhone()
     * @uses Address::setFax()
     * @uses Address::setEmail()
     * @uses Address::setComment()
     * @uses Address::setIaccount()
     * @param string $name1
     * @param string $street
     * @param string $country
     * @param string $zipCode
     * @param string $city
     * @param string $name2
     * @param string $houseNo
     * @param string $state
     * @param int $gln
     * @param string $customerNumber
     * @param string $contact
     * @param string $phone
     * @param string $fax
     * @param string $email
     * @param string $comment
     * @param string $iaccount
     */
    public function __construct($name1 = null, $street = null, $country = null, $zipCode = null, $city = null, $name2 = null, $houseNo = null, $state = null, $gln = null, $customerNumber = null, $contact = null, $phone = null, $fax = null, $email = null, $comment = null, $iaccount = null)
    {
        $this
            ->setName1($name1)
            ->setStreet($street)
            ->setCountry($country)
            ->setZipCode($zipCode)
            ->setCity($city)
            ->setName2($name2)
            ->setHouseNo($houseNo)
            ->setState($state)
            ->setGln($gln)
            ->setCustomerNumber($customerNumber)
            ->setContact($contact)
            ->setPhone($phone)
            ->setFax($fax)
            ->setEmail($email)
            ->setComment($comment)
            ->setIaccount($iaccount);
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \cycro\StructType\Address
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name1) && strlen($name1) > 50) || (is_array($name1) && count($name1) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name1) ? strlen($name1) : count($name1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \cycro\StructType\Address
     */
    public function setStreet($street = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($street) && strlen($street) > 50) || (is_array($street) && count($street) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($street) ? strlen($street) : count($street)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \cycro\StructType\Address
     */
    public function setCountry($country = null)
    {
        // validation for constraint: length
        if ((is_scalar($country) && strlen($country) !== 2) || (is_array($country) && count($country) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \cycro\StructType\Address
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zipCode) && strlen($zipCode) > 9) || (is_array($zipCode) && count($zipCode) > 9)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s) at most, "%d" length given', is_scalar($zipCode) ? strlen($zipCode) : count($zipCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \cycro\StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($city) && strlen($city) > 50) || (is_array($city) && count($city) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($city) ? strlen($city) : count($city)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get name2 value
     * @return string|null
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \cycro\StructType\Address
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name2) && strlen($name2) > 35) || (is_array($name2) && count($name2) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($name2) ? strlen($name2) : count($name2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get houseNo value
     * @return string|null
     */
    public function getHouseNo()
    {
        return $this->houseNo;
    }
    /**
     * Set houseNo value
     * @param string $houseNo
     * @return \cycro\StructType\Address
     */
    public function setHouseNo($houseNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($houseNo) && strlen($houseNo) > 8) || (is_array($houseNo) && count($houseNo) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($houseNo) ? strlen($houseNo) : count($houseNo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($houseNo) && !is_string($houseNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNo)), __LINE__);
        }
        $this->houseNo = $houseNo;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \cycro\StructType\Address
     */
    public function setState($state = null)
    {
        // validation for constraint: length
        if ((is_scalar($state) && strlen($state) !== 2) || (is_array($state) && count($state) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get gln value
     * @return int|null
     */
    public function getGln()
    {
        return $this->gln;
    }
    /**
     * Set gln value
     * @param int $gln
     * @return \cycro\StructType\Address
     */
    public function setGln($gln = null)
    {
        // validation for constraint: maxInclusive
        if ($gln > 9999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999999999999, "%s" given', $gln), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($gln) && !is_numeric($gln)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gln)), __LINE__);
        }
        $this->gln = $gln;
        return $this;
    }
    /**
     * Get customerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->customerNumber;
    }
    /**
     * Set customerNumber value
     * @param string $customerNumber
     * @return \cycro\StructType\Address
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customerNumber) && strlen($customerNumber) > 17) || (is_array($customerNumber) && count($customerNumber) > 17)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 17 element(s) or a scalar of 17 character(s) at most, "%d" length given', is_scalar($customerNumber) ? strlen($customerNumber) : count($customerNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNumber)), __LINE__);
        }
        $this->customerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param string $contact
     * @return \cycro\StructType\Address
     */
    public function setContact($contact = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contact) && strlen($contact) > 35) || (is_array($contact) && count($contact) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($contact) ? strlen($contact) : count($contact)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contact)), __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \cycro\StructType\Address
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($phone) && strlen($phone) > 20) || (is_array($phone) && count($phone) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($phone) ? strlen($phone) : count($phone)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \cycro\StructType\Address
     */
    public function setFax($fax = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fax) && strlen($fax) > 30) || (is_array($fax) && count($fax) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($fax) ? strlen($fax) : count($fax)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \cycro\StructType\Address
     */
    public function setEmail($email = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($email) && strlen($email) > 50) || (is_array($email) && count($email) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($email) ? strlen($email) : count($email)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \cycro\StructType\Address
     */
    public function setComment($comment = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($comment) && strlen($comment) > 70) || (is_array($comment) && count($comment) > 70)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 70 element(s) or a scalar of 70 character(s) at most, "%d" length given', is_scalar($comment) ? strlen($comment) : count($comment)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get iaccount value
     * @return string|null
     */
    public function getIaccount()
    {
        return $this->iaccount;
    }
    /**
     * Set iaccount value
     * @param string $iaccount
     * @return \cycro\StructType\Address
     */
    public function setIaccount($iaccount = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iaccount) && strlen($iaccount) > 50) || (is_array($iaccount) && count($iaccount) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($iaccount) ? strlen($iaccount) : count($iaccount)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iaccount) && !is_string($iaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iaccount)), __LINE__);
        }
        $this->iaccount = $iaccount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cycro\StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
