<?php

namespace cycro\EnumType;

/**
 * This class stands for packingCode EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Defines packing code. Possible values are:0A = thin sheet packing0A1 = thin sheet packing with non removable head0A2 = thin sheet packing with removable head1A = steel barrel1A1 = steel barrel with non removable head1A2 = steel
 * barrel with removable head1B = aluminium barrel1B1 = aluminium barrel with non removable head1B2 = aluminium barrel with removable head1H = plastics barrel1H1 = plastics barrel with non removable head1H2 = plastics barrel with removable head3A =
 * steel canister3A1 = steel canister with non removable head3A2 = steel canister with removable head3B = aluminium canister,3B1 = aluminium canister with non removable head3B2 = aluminium canister with removable head3H = plastics canister,3H1 =
 * plastics canister with non removable head3H2 = plastics canister with removable head4A = steel crates4B = aluminium crate4D = plywood crate4G = cardboard crate4H = plastics crate4H1 = plastics crate plastics expanded4H2 = plastics crate plastics
 * solid5H = plastics bags5M = paper bags6H = combination packings
 * @subpackage Enumerations
 */
class PackingCode
{
    /**
     * Constant for value '0A'
     * @return string '0A'
     */
    const VALUE_0_A = '0A';
    /**
     * Constant for value '0A1'
     * @return string '0A1'
     */
    const VALUE_0_A_1 = '0A1';
    /**
     * Constant for value '0A2'
     * @return string '0A2'
     */
    const VALUE_0_A_2 = '0A2';
    /**
     * Constant for value '1A'
     * @return string '1A'
     */
    const VALUE_1_A = '1A';
    /**
     * Constant for value '1A1'
     * @return string '1A1'
     */
    const VALUE_1_A_1 = '1A1';
    /**
     * Constant for value '1A2'
     * @return string '1A2'
     */
    const VALUE_1_A_2 = '1A2';
    /**
     * Constant for value '1B'
     * @return string '1B'
     */
    const VALUE_1_B = '1B';
    /**
     * Constant for value '1B1'
     * @return string '1B1'
     */
    const VALUE_1_B_1 = '1B1';
    /**
     * Constant for value '1B2'
     * @return string '1B2'
     */
    const VALUE_1_B_2 = '1B2';
    /**
     * Constant for value '1H'
     * @return string '1H'
     */
    const VALUE_1_H = '1H';
    /**
     * Constant for value '1H1'
     * @return string '1H1'
     */
    const VALUE_1_H_1 = '1H1';
    /**
     * Constant for value '1H2'
     * @return string '1H2'
     */
    const VALUE_1_H_2 = '1H2';
    /**
     * Constant for value '3A'
     * @return string '3A'
     */
    const VALUE_3_A = '3A';
    /**
     * Constant for value '3A1'
     * @return string '3A1'
     */
    const VALUE_3_A_1 = '3A1';
    /**
     * Constant for value '3A2'
     * @return string '3A2'
     */
    const VALUE_3_A_2 = '3A2';
    /**
     * Constant for value '3B'
     * @return string '3B'
     */
    const VALUE_3_B = '3B';
    /**
     * Constant for value '3B1'
     * @return string '3B1'
     */
    const VALUE_3_B_1 = '3B1';
    /**
     * Constant for value '3B2'
     * @return string '3B2'
     */
    const VALUE_3_B_2 = '3B2';
    /**
     * Constant for value '3H'
     * @return string '3H'
     */
    const VALUE_3_H = '3H';
    /**
     * Constant for value '3H1'
     * @return string '3H1'
     */
    const VALUE_3_H_1 = '3H1';
    /**
     * Constant for value '3H2'
     * @return string '3H2'
     */
    const VALUE_3_H_2 = '3H2';
    /**
     * Constant for value '4A'
     * @return string '4A'
     */
    const VALUE_4_A = '4A';
    /**
     * Constant for value '4B'
     * @return string '4B'
     */
    const VALUE_4_B = '4B';
    /**
     * Constant for value '4D'
     * @return string '4D'
     */
    const VALUE_4_D = '4D';
    /**
     * Constant for value '4G'
     * @return string '4G'
     */
    const VALUE_4_G = '4G';
    /**
     * Constant for value '4H'
     * @return string '4H'
     */
    const VALUE_4_H = '4H';
    /**
     * Constant for value '4H1'
     * @return string '4H1'
     */
    const VALUE_4_H_1 = '4H1';
    /**
     * Constant for value '4H2'
     * @return string '4H2'
     */
    const VALUE_4_H_2 = '4H2';
    /**
     * Constant for value '5H'
     * @return string '5H'
     */
    const VALUE_5_H = '5H';
    /**
     * Constant for value '5M'
     * @return string '5M'
     */
    const VALUE_5_M = '5M';
    /**
     * Constant for value '6H'
     * @return string '6H'
     */
    const VALUE_6_H = '6H';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_0_A
     * @uses self::VALUE_0_A_1
     * @uses self::VALUE_0_A_2
     * @uses self::VALUE_1_A
     * @uses self::VALUE_1_A_1
     * @uses self::VALUE_1_A_2
     * @uses self::VALUE_1_B
     * @uses self::VALUE_1_B_1
     * @uses self::VALUE_1_B_2
     * @uses self::VALUE_1_H
     * @uses self::VALUE_1_H_1
     * @uses self::VALUE_1_H_2
     * @uses self::VALUE_3_A
     * @uses self::VALUE_3_A_1
     * @uses self::VALUE_3_A_2
     * @uses self::VALUE_3_B
     * @uses self::VALUE_3_B_1
     * @uses self::VALUE_3_B_2
     * @uses self::VALUE_3_H
     * @uses self::VALUE_3_H_1
     * @uses self::VALUE_3_H_2
     * @uses self::VALUE_4_A
     * @uses self::VALUE_4_B
     * @uses self::VALUE_4_D
     * @uses self::VALUE_4_G
     * @uses self::VALUE_4_H
     * @uses self::VALUE_4_H_1
     * @uses self::VALUE_4_H_2
     * @uses self::VALUE_5_H
     * @uses self::VALUE_5_M
     * @uses self::VALUE_6_H
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_0_A,
            self::VALUE_0_A_1,
            self::VALUE_0_A_2,
            self::VALUE_1_A,
            self::VALUE_1_A_1,
            self::VALUE_1_A_2,
            self::VALUE_1_B,
            self::VALUE_1_B_1,
            self::VALUE_1_B_2,
            self::VALUE_1_H,
            self::VALUE_1_H_1,
            self::VALUE_1_H_2,
            self::VALUE_3_A,
            self::VALUE_3_A_1,
            self::VALUE_3_A_2,
            self::VALUE_3_B,
            self::VALUE_3_B_1,
            self::VALUE_3_B_2,
            self::VALUE_3_H,
            self::VALUE_3_H_1,
            self::VALUE_3_H_2,
            self::VALUE_4_A,
            self::VALUE_4_B,
            self::VALUE_4_D,
            self::VALUE_4_G,
            self::VALUE_4_H,
            self::VALUE_4_H_1,
            self::VALUE_4_H_2,
            self::VALUE_5_H,
            self::VALUE_5_M,
            self::VALUE_6_H,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
