<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TerminalDataDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TerminalDataDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class TerminalDataDefinition extends AbstractStructBase
{
    /**
     * The SourceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceType;
    /**
     * The TerminalCommands
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTerminalCommandDefinition
     */
    public $TerminalCommands;
    /**
     * The TerminalPreferences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTerminalPreferencesDefinition
     */
    public $TerminalPreferences;
    /**
     * Constructor method for TerminalDataDefinition
     * @uses TerminalDataDefinition::setSourceType()
     * @uses TerminalDataDefinition::setTerminalCommands()
     * @uses TerminalDataDefinition::setTerminalPreferences()
     * @param string $sourceType
     * @param \ArrayType\ArrayOfTerminalCommandDefinition $terminalCommands
     * @param \ArrayType\ArrayOfTerminalPreferencesDefinition $terminalPreferences
     */
    public function __construct($sourceType = null, \ArrayType\ArrayOfTerminalCommandDefinition $terminalCommands = null, \ArrayType\ArrayOfTerminalPreferencesDefinition $terminalPreferences = null)
    {
        $this
            ->setSourceType($sourceType)
            ->setTerminalCommands($terminalCommands)
            ->setTerminalPreferences($terminalPreferences);
    }
    /**
     * Get SourceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceType()
    {
        return isset($this->SourceType) ? $this->SourceType : null;
    }
    /**
     * Set SourceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceType
     * @return \StructType\TerminalDataDefinition
     */
    public function setSourceType($sourceType = null)
    {
        // validation for constraint: string
        if (!is_null($sourceType) && !is_string($sourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceType)), __LINE__);
        }
        if (is_null($sourceType) || (is_array($sourceType) && empty($sourceType))) {
            unset($this->SourceType);
        } else {
            $this->SourceType = $sourceType;
        }
        return $this;
    }
    /**
     * Get TerminalCommands value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTerminalCommandDefinition|null
     */
    public function getTerminalCommands()
    {
        return isset($this->TerminalCommands) ? $this->TerminalCommands : null;
    }
    /**
     * Set TerminalCommands value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTerminalCommandDefinition $terminalCommands
     * @return \StructType\TerminalDataDefinition
     */
    public function setTerminalCommands(\ArrayType\ArrayOfTerminalCommandDefinition $terminalCommands = null)
    {
        if (is_null($terminalCommands) || (is_array($terminalCommands) && empty($terminalCommands))) {
            unset($this->TerminalCommands);
        } else {
            $this->TerminalCommands = $terminalCommands;
        }
        return $this;
    }
    /**
     * Get TerminalPreferences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTerminalPreferencesDefinition|null
     */
    public function getTerminalPreferences()
    {
        return isset($this->TerminalPreferences) ? $this->TerminalPreferences : null;
    }
    /**
     * Set TerminalPreferences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTerminalPreferencesDefinition $terminalPreferences
     * @return \StructType\TerminalDataDefinition
     */
    public function setTerminalPreferences(\ArrayType\ArrayOfTerminalPreferencesDefinition $terminalPreferences = null)
    {
        if (is_null($terminalPreferences) || (is_array($terminalPreferences) && empty($terminalPreferences))) {
            unset($this->TerminalPreferences);
        } else {
            $this->TerminalPreferences = $terminalPreferences;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TerminalDataDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
