<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomTypeDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoomTypeDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class RoomTypeDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The Bedding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Bedding;
    /**
     * The CategoryRoom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CategoryRoomDefinition
     */
    public $CategoryRoom;
    /**
     * The Characteristics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Characteristics;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IsUsedInFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsUsedInFare;
    /**
     * The MaxPaxTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxPaxTotal;
    /**
     * The NumPaxBaseFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumPaxBaseFare;
    /**
     * Constructor method for RoomTypeDefinition
     * @uses RoomTypeDefinition::setActionType()
     * @uses RoomTypeDefinition::setBedding()
     * @uses RoomTypeDefinition::setCategoryRoom()
     * @uses RoomTypeDefinition::setCharacteristics()
     * @uses RoomTypeDefinition::setCode()
     * @uses RoomTypeDefinition::setDescription()
     * @uses RoomTypeDefinition::setId()
     * @uses RoomTypeDefinition::setIsUsedInFare()
     * @uses RoomTypeDefinition::setMaxPaxTotal()
     * @uses RoomTypeDefinition::setNumPaxBaseFare()
     * @param string $actionType
     * @param string $bedding
     * @param \StructType\CategoryRoomDefinition $categoryRoom
     * @param string $characteristics
     * @param string $code
     * @param string $description
     * @param int $id
     * @param bool $isUsedInFare
     * @param int $maxPaxTotal
     * @param int $numPaxBaseFare
     */
    public function __construct($actionType = null, $bedding = null, \StructType\CategoryRoomDefinition $categoryRoom = null, $characteristics = null, $code = null, $description = null, $id = null, $isUsedInFare = null, $maxPaxTotal = null, $numPaxBaseFare = null)
    {
        $this
            ->setActionType($actionType)
            ->setBedding($bedding)
            ->setCategoryRoom($categoryRoom)
            ->setCharacteristics($characteristics)
            ->setCode($code)
            ->setDescription($description)
            ->setId($id)
            ->setIsUsedInFare($isUsedInFare)
            ->setMaxPaxTotal($maxPaxTotal)
            ->setNumPaxBaseFare($numPaxBaseFare);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\RoomTypeDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get Bedding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBedding()
    {
        return isset($this->Bedding) ? $this->Bedding : null;
    }
    /**
     * Set Bedding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\BedType::valueIsValid()
     * @uses \EnumType\BedType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bedding
     * @return \StructType\RoomTypeDefinition
     */
    public function setBedding($bedding = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BedType::valueIsValid($bedding)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bedding, implode(', ', \EnumType\BedType::getValidValues())), __LINE__);
        }
        if (is_null($bedding) || (is_array($bedding) && empty($bedding))) {
            unset($this->Bedding);
        } else {
            $this->Bedding = $bedding;
        }
        return $this;
    }
    /**
     * Get CategoryRoom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CategoryRoomDefinition|null
     */
    public function getCategoryRoom()
    {
        return isset($this->CategoryRoom) ? $this->CategoryRoom : null;
    }
    /**
     * Set CategoryRoom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CategoryRoomDefinition $categoryRoom
     * @return \StructType\RoomTypeDefinition
     */
    public function setCategoryRoom(\StructType\CategoryRoomDefinition $categoryRoom = null)
    {
        if (is_null($categoryRoom) || (is_array($categoryRoom) && empty($categoryRoom))) {
            unset($this->CategoryRoom);
        } else {
            $this->CategoryRoom = $categoryRoom;
        }
        return $this;
    }
    /**
     * Get Characteristics value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCharacteristics()
    {
        return isset($this->Characteristics) ? $this->Characteristics : null;
    }
    /**
     * Set Characteristics value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $characteristics
     * @return \StructType\RoomTypeDefinition
     */
    public function setCharacteristics($characteristics = null)
    {
        // validation for constraint: string
        if (!is_null($characteristics) && !is_string($characteristics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($characteristics)), __LINE__);
        }
        if (is_null($characteristics) || (is_array($characteristics) && empty($characteristics))) {
            unset($this->Characteristics);
        } else {
            $this->Characteristics = $characteristics;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\RoomTypeDefinition
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\RoomTypeDefinition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\RoomTypeDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsUsedInFare value
     * @return bool|null
     */
    public function getIsUsedInFare()
    {
        return $this->IsUsedInFare;
    }
    /**
     * Set IsUsedInFare value
     * @param bool $isUsedInFare
     * @return \StructType\RoomTypeDefinition
     */
    public function setIsUsedInFare($isUsedInFare = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUsedInFare) && !is_bool($isUsedInFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUsedInFare)), __LINE__);
        }
        $this->IsUsedInFare = $isUsedInFare;
        return $this;
    }
    /**
     * Get MaxPaxTotal value
     * @return int|null
     */
    public function getMaxPaxTotal()
    {
        return $this->MaxPaxTotal;
    }
    /**
     * Set MaxPaxTotal value
     * @param int $maxPaxTotal
     * @return \StructType\RoomTypeDefinition
     */
    public function setMaxPaxTotal($maxPaxTotal = null)
    {
        // validation for constraint: int
        if (!is_null($maxPaxTotal) && !is_numeric($maxPaxTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxPaxTotal)), __LINE__);
        }
        $this->MaxPaxTotal = $maxPaxTotal;
        return $this;
    }
    /**
     * Get NumPaxBaseFare value
     * @return int|null
     */
    public function getNumPaxBaseFare()
    {
        return $this->NumPaxBaseFare;
    }
    /**
     * Set NumPaxBaseFare value
     * @param int $numPaxBaseFare
     * @return \StructType\RoomTypeDefinition
     */
    public function setNumPaxBaseFare($numPaxBaseFare = null)
    {
        // validation for constraint: int
        if (!is_null($numPaxBaseFare) && !is_numeric($numPaxBaseFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numPaxBaseFare)), __LINE__);
        }
        $this->NumPaxBaseFare = $numPaxBaseFare;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomTypeDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
