<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomOptionDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoomOptionDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class RoomOptionDefinition extends AbstractStructBase
{
    /**
     * The AvailabilityStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The Board
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BoardDefinition
     */
    public $Board;
    /**
     * The CancellationPolicies
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHotelCancellationPolicyDefinition
     */
    public $CancellationPolicies;
    /**
     * The Characteristics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Characteristics;
    /**
     * The Cost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CostDefinition
     */
    public $Cost;
    /**
     * The CustomArgument
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomArgument;
    /**
     * The DepositInfos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDepositInfoDefinition
     */
    public $DepositInfos;
    /**
     * The GuaranteeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GuaranteeType;
    /**
     * The HotelFareCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelFareCode;
    /**
     * The HotelFareDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelFareDescription;
    /**
     * The HotelFareId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HotelFareId;
    /**
     * The HotelFareVoucherDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelFareVoucherDescription;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The InventoryBlockId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InventoryBlockId;
    /**
     * The InventorySource
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InventorySource;
    /**
     * The NightPrices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHotelRoomNightPriceDefinition
     */
    public $NightPrices;
    /**
     * The Occupancy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPassengerCountDefinition
     */
    public $Occupancy;
    /**
     * The ProductPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductPriceDefinition
     */
    public $ProductPrice;
    /**
     * The PromotionalText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromotionalText;
    /**
     * The ReservationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationCode;
    /**
     * The RoomCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RoomCount;
    /**
     * The RoomType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RoomTypeDefinition
     */
    public $RoomType;
    /**
     * The Supplier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProviderInfoDefinition
     */
    public $Supplier;
    /**
     * The TTL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TTL;
    /**
     * The TransactionToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionToken;
    /**
     * Constructor method for RoomOptionDefinition
     * @uses RoomOptionDefinition::setAvailabilityStatus()
     * @uses RoomOptionDefinition::setBoard()
     * @uses RoomOptionDefinition::setCancellationPolicies()
     * @uses RoomOptionDefinition::setCharacteristics()
     * @uses RoomOptionDefinition::setCost()
     * @uses RoomOptionDefinition::setCustomArgument()
     * @uses RoomOptionDefinition::setDepositInfos()
     * @uses RoomOptionDefinition::setGuaranteeType()
     * @uses RoomOptionDefinition::setHotelFareCode()
     * @uses RoomOptionDefinition::setHotelFareDescription()
     * @uses RoomOptionDefinition::setHotelFareId()
     * @uses RoomOptionDefinition::setHotelFareVoucherDescription()
     * @uses RoomOptionDefinition::setId()
     * @uses RoomOptionDefinition::setInventoryBlockId()
     * @uses RoomOptionDefinition::setInventorySource()
     * @uses RoomOptionDefinition::setNightPrices()
     * @uses RoomOptionDefinition::setOccupancy()
     * @uses RoomOptionDefinition::setProductPrice()
     * @uses RoomOptionDefinition::setPromotionalText()
     * @uses RoomOptionDefinition::setReservationCode()
     * @uses RoomOptionDefinition::setRoomCount()
     * @uses RoomOptionDefinition::setRoomType()
     * @uses RoomOptionDefinition::setSupplier()
     * @uses RoomOptionDefinition::setTTL()
     * @uses RoomOptionDefinition::setTransactionToken()
     * @param string $availabilityStatus
     * @param \StructType\BoardDefinition $board
     * @param \ArrayType\ArrayOfHotelCancellationPolicyDefinition $cancellationPolicies
     * @param string $characteristics
     * @param \StructType\CostDefinition $cost
     * @param string $customArgument
     * @param \ArrayType\ArrayOfDepositInfoDefinition $depositInfos
     * @param string $guaranteeType
     * @param string $hotelFareCode
     * @param string $hotelFareDescription
     * @param int $hotelFareId
     * @param string $hotelFareVoucherDescription
     * @param int $id
     * @param int $inventoryBlockId
     * @param string $inventorySource
     * @param \ArrayType\ArrayOfHotelRoomNightPriceDefinition $nightPrices
     * @param \ArrayType\ArrayOfPassengerCountDefinition $occupancy
     * @param \StructType\ProductPriceDefinition $productPrice
     * @param string $promotionalText
     * @param string $reservationCode
     * @param int $roomCount
     * @param \StructType\RoomTypeDefinition $roomType
     * @param \StructType\ProviderInfoDefinition $supplier
     * @param string $tTL
     * @param string $transactionToken
     */
    public function __construct($availabilityStatus = null, \StructType\BoardDefinition $board = null, \ArrayType\ArrayOfHotelCancellationPolicyDefinition $cancellationPolicies = null, $characteristics = null, \StructType\CostDefinition $cost = null, $customArgument = null, \ArrayType\ArrayOfDepositInfoDefinition $depositInfos = null, $guaranteeType = null, $hotelFareCode = null, $hotelFareDescription = null, $hotelFareId = null, $hotelFareVoucherDescription = null, $id = null, $inventoryBlockId = null, $inventorySource = null, \ArrayType\ArrayOfHotelRoomNightPriceDefinition $nightPrices = null, \ArrayType\ArrayOfPassengerCountDefinition $occupancy = null, \StructType\ProductPriceDefinition $productPrice = null, $promotionalText = null, $reservationCode = null, $roomCount = null, \StructType\RoomTypeDefinition $roomType = null, \StructType\ProviderInfoDefinition $supplier = null, $tTL = null, $transactionToken = null)
    {
        $this
            ->setAvailabilityStatus($availabilityStatus)
            ->setBoard($board)
            ->setCancellationPolicies($cancellationPolicies)
            ->setCharacteristics($characteristics)
            ->setCost($cost)
            ->setCustomArgument($customArgument)
            ->setDepositInfos($depositInfos)
            ->setGuaranteeType($guaranteeType)
            ->setHotelFareCode($hotelFareCode)
            ->setHotelFareDescription($hotelFareDescription)
            ->setHotelFareId($hotelFareId)
            ->setHotelFareVoucherDescription($hotelFareVoucherDescription)
            ->setId($id)
            ->setInventoryBlockId($inventoryBlockId)
            ->setInventorySource($inventorySource)
            ->setNightPrices($nightPrices)
            ->setOccupancy($occupancy)
            ->setProductPrice($productPrice)
            ->setPromotionalText($promotionalText)
            ->setReservationCode($reservationCode)
            ->setRoomCount($roomCount)
            ->setRoomType($roomType)
            ->setSupplier($supplier)
            ->setTTL($tTL)
            ->setTransactionToken($transactionToken);
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \EnumType\AvailabilityStatusType::valueIsValid()
     * @uses \EnumType\AvailabilityStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \StructType\RoomOptionDefinition
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AvailabilityStatusType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $availabilityStatus, implode(', ', \EnumType\AvailabilityStatusType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get Board value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BoardDefinition|null
     */
    public function getBoard()
    {
        return isset($this->Board) ? $this->Board : null;
    }
    /**
     * Set Board value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BoardDefinition $board
     * @return \StructType\RoomOptionDefinition
     */
    public function setBoard(\StructType\BoardDefinition $board = null)
    {
        if (is_null($board) || (is_array($board) && empty($board))) {
            unset($this->Board);
        } else {
            $this->Board = $board;
        }
        return $this;
    }
    /**
     * Get CancellationPolicies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHotelCancellationPolicyDefinition|null
     */
    public function getCancellationPolicies()
    {
        return isset($this->CancellationPolicies) ? $this->CancellationPolicies : null;
    }
    /**
     * Set CancellationPolicies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHotelCancellationPolicyDefinition $cancellationPolicies
     * @return \StructType\RoomOptionDefinition
     */
    public function setCancellationPolicies(\ArrayType\ArrayOfHotelCancellationPolicyDefinition $cancellationPolicies = null)
    {
        if (is_null($cancellationPolicies) || (is_array($cancellationPolicies) && empty($cancellationPolicies))) {
            unset($this->CancellationPolicies);
        } else {
            $this->CancellationPolicies = $cancellationPolicies;
        }
        return $this;
    }
    /**
     * Get Characteristics value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCharacteristics()
    {
        return isset($this->Characteristics) ? $this->Characteristics : null;
    }
    /**
     * Set Characteristics value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $characteristics
     * @return \StructType\RoomOptionDefinition
     */
    public function setCharacteristics($characteristics = null)
    {
        // validation for constraint: string
        if (!is_null($characteristics) && !is_string($characteristics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($characteristics)), __LINE__);
        }
        if (is_null($characteristics) || (is_array($characteristics) && empty($characteristics))) {
            unset($this->Characteristics);
        } else {
            $this->Characteristics = $characteristics;
        }
        return $this;
    }
    /**
     * Get Cost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CostDefinition|null
     */
    public function getCost()
    {
        return isset($this->Cost) ? $this->Cost : null;
    }
    /**
     * Set Cost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CostDefinition $cost
     * @return \StructType\RoomOptionDefinition
     */
    public function setCost(\StructType\CostDefinition $cost = null)
    {
        if (is_null($cost) || (is_array($cost) && empty($cost))) {
            unset($this->Cost);
        } else {
            $this->Cost = $cost;
        }
        return $this;
    }
    /**
     * Get CustomArgument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomArgument()
    {
        return isset($this->CustomArgument) ? $this->CustomArgument : null;
    }
    /**
     * Set CustomArgument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customArgument
     * @return \StructType\RoomOptionDefinition
     */
    public function setCustomArgument($customArgument = null)
    {
        // validation for constraint: string
        if (!is_null($customArgument) && !is_string($customArgument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customArgument)), __LINE__);
        }
        if (is_null($customArgument) || (is_array($customArgument) && empty($customArgument))) {
            unset($this->CustomArgument);
        } else {
            $this->CustomArgument = $customArgument;
        }
        return $this;
    }
    /**
     * Get DepositInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDepositInfoDefinition|null
     */
    public function getDepositInfos()
    {
        return isset($this->DepositInfos) ? $this->DepositInfos : null;
    }
    /**
     * Set DepositInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDepositInfoDefinition $depositInfos
     * @return \StructType\RoomOptionDefinition
     */
    public function setDepositInfos(\ArrayType\ArrayOfDepositInfoDefinition $depositInfos = null)
    {
        if (is_null($depositInfos) || (is_array($depositInfos) && empty($depositInfos))) {
            unset($this->DepositInfos);
        } else {
            $this->DepositInfos = $depositInfos;
        }
        return $this;
    }
    /**
     * Get GuaranteeType value
     * @return string|null
     */
    public function getGuaranteeType()
    {
        return $this->GuaranteeType;
    }
    /**
     * Set GuaranteeType value
     * @uses \EnumType\GuaranteeType::valueIsValid()
     * @uses \EnumType\GuaranteeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guaranteeType
     * @return \StructType\RoomOptionDefinition
     */
    public function setGuaranteeType($guaranteeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GuaranteeType::valueIsValid($guaranteeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $guaranteeType, implode(', ', \EnumType\GuaranteeType::getValidValues())), __LINE__);
        }
        $this->GuaranteeType = $guaranteeType;
        return $this;
    }
    /**
     * Get HotelFareCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelFareCode()
    {
        return isset($this->HotelFareCode) ? $this->HotelFareCode : null;
    }
    /**
     * Set HotelFareCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelFareCode
     * @return \StructType\RoomOptionDefinition
     */
    public function setHotelFareCode($hotelFareCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelFareCode) && !is_string($hotelFareCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelFareCode)), __LINE__);
        }
        if (is_null($hotelFareCode) || (is_array($hotelFareCode) && empty($hotelFareCode))) {
            unset($this->HotelFareCode);
        } else {
            $this->HotelFareCode = $hotelFareCode;
        }
        return $this;
    }
    /**
     * Get HotelFareDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelFareDescription()
    {
        return isset($this->HotelFareDescription) ? $this->HotelFareDescription : null;
    }
    /**
     * Set HotelFareDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelFareDescription
     * @return \StructType\RoomOptionDefinition
     */
    public function setHotelFareDescription($hotelFareDescription = null)
    {
        // validation for constraint: string
        if (!is_null($hotelFareDescription) && !is_string($hotelFareDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelFareDescription)), __LINE__);
        }
        if (is_null($hotelFareDescription) || (is_array($hotelFareDescription) && empty($hotelFareDescription))) {
            unset($this->HotelFareDescription);
        } else {
            $this->HotelFareDescription = $hotelFareDescription;
        }
        return $this;
    }
    /**
     * Get HotelFareId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHotelFareId()
    {
        return isset($this->HotelFareId) ? $this->HotelFareId : null;
    }
    /**
     * Set HotelFareId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hotelFareId
     * @return \StructType\RoomOptionDefinition
     */
    public function setHotelFareId($hotelFareId = null)
    {
        // validation for constraint: int
        if (!is_null($hotelFareId) && !is_numeric($hotelFareId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hotelFareId)), __LINE__);
        }
        if (is_null($hotelFareId) || (is_array($hotelFareId) && empty($hotelFareId))) {
            unset($this->HotelFareId);
        } else {
            $this->HotelFareId = $hotelFareId;
        }
        return $this;
    }
    /**
     * Get HotelFareVoucherDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelFareVoucherDescription()
    {
        return isset($this->HotelFareVoucherDescription) ? $this->HotelFareVoucherDescription : null;
    }
    /**
     * Set HotelFareVoucherDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelFareVoucherDescription
     * @return \StructType\RoomOptionDefinition
     */
    public function setHotelFareVoucherDescription($hotelFareVoucherDescription = null)
    {
        // validation for constraint: string
        if (!is_null($hotelFareVoucherDescription) && !is_string($hotelFareVoucherDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelFareVoucherDescription)), __LINE__);
        }
        if (is_null($hotelFareVoucherDescription) || (is_array($hotelFareVoucherDescription) && empty($hotelFareVoucherDescription))) {
            unset($this->HotelFareVoucherDescription);
        } else {
            $this->HotelFareVoucherDescription = $hotelFareVoucherDescription;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\RoomOptionDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get InventoryBlockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInventoryBlockId()
    {
        return isset($this->InventoryBlockId) ? $this->InventoryBlockId : null;
    }
    /**
     * Set InventoryBlockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inventoryBlockId
     * @return \StructType\RoomOptionDefinition
     */
    public function setInventoryBlockId($inventoryBlockId = null)
    {
        // validation for constraint: int
        if (!is_null($inventoryBlockId) && !is_numeric($inventoryBlockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($inventoryBlockId)), __LINE__);
        }
        if (is_null($inventoryBlockId) || (is_array($inventoryBlockId) && empty($inventoryBlockId))) {
            unset($this->InventoryBlockId);
        } else {
            $this->InventoryBlockId = $inventoryBlockId;
        }
        return $this;
    }
    /**
     * Get InventorySource value
     * @return string|null
     */
    public function getInventorySource()
    {
        return $this->InventorySource;
    }
    /**
     * Set InventorySource value
     * @uses \EnumType\InventorySourceType::valueIsValid()
     * @uses \EnumType\InventorySourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inventorySource
     * @return \StructType\RoomOptionDefinition
     */
    public function setInventorySource($inventorySource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InventorySourceType::valueIsValid($inventorySource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $inventorySource, implode(', ', \EnumType\InventorySourceType::getValidValues())), __LINE__);
        }
        $this->InventorySource = $inventorySource;
        return $this;
    }
    /**
     * Get NightPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHotelRoomNightPriceDefinition|null
     */
    public function getNightPrices()
    {
        return isset($this->NightPrices) ? $this->NightPrices : null;
    }
    /**
     * Set NightPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHotelRoomNightPriceDefinition $nightPrices
     * @return \StructType\RoomOptionDefinition
     */
    public function setNightPrices(\ArrayType\ArrayOfHotelRoomNightPriceDefinition $nightPrices = null)
    {
        if (is_null($nightPrices) || (is_array($nightPrices) && empty($nightPrices))) {
            unset($this->NightPrices);
        } else {
            $this->NightPrices = $nightPrices;
        }
        return $this;
    }
    /**
     * Get Occupancy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPassengerCountDefinition|null
     */
    public function getOccupancy()
    {
        return isset($this->Occupancy) ? $this->Occupancy : null;
    }
    /**
     * Set Occupancy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPassengerCountDefinition $occupancy
     * @return \StructType\RoomOptionDefinition
     */
    public function setOccupancy(\ArrayType\ArrayOfPassengerCountDefinition $occupancy = null)
    {
        if (is_null($occupancy) || (is_array($occupancy) && empty($occupancy))) {
            unset($this->Occupancy);
        } else {
            $this->Occupancy = $occupancy;
        }
        return $this;
    }
    /**
     * Get ProductPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductPriceDefinition|null
     */
    public function getProductPrice()
    {
        return isset($this->ProductPrice) ? $this->ProductPrice : null;
    }
    /**
     * Set ProductPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProductPriceDefinition $productPrice
     * @return \StructType\RoomOptionDefinition
     */
    public function setProductPrice(\StructType\ProductPriceDefinition $productPrice = null)
    {
        if (is_null($productPrice) || (is_array($productPrice) && empty($productPrice))) {
            unset($this->ProductPrice);
        } else {
            $this->ProductPrice = $productPrice;
        }
        return $this;
    }
    /**
     * Get PromotionalText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromotionalText()
    {
        return isset($this->PromotionalText) ? $this->PromotionalText : null;
    }
    /**
     * Set PromotionalText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promotionalText
     * @return \StructType\RoomOptionDefinition
     */
    public function setPromotionalText($promotionalText = null)
    {
        // validation for constraint: string
        if (!is_null($promotionalText) && !is_string($promotionalText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotionalText)), __LINE__);
        }
        if (is_null($promotionalText) || (is_array($promotionalText) && empty($promotionalText))) {
            unset($this->PromotionalText);
        } else {
            $this->PromotionalText = $promotionalText;
        }
        return $this;
    }
    /**
     * Get ReservationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationCode()
    {
        return isset($this->ReservationCode) ? $this->ReservationCode : null;
    }
    /**
     * Set ReservationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationCode
     * @return \StructType\RoomOptionDefinition
     */
    public function setReservationCode($reservationCode = null)
    {
        // validation for constraint: string
        if (!is_null($reservationCode) && !is_string($reservationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationCode)), __LINE__);
        }
        if (is_null($reservationCode) || (is_array($reservationCode) && empty($reservationCode))) {
            unset($this->ReservationCode);
        } else {
            $this->ReservationCode = $reservationCode;
        }
        return $this;
    }
    /**
     * Get RoomCount value
     * @return int|null
     */
    public function getRoomCount()
    {
        return $this->RoomCount;
    }
    /**
     * Set RoomCount value
     * @param int $roomCount
     * @return \StructType\RoomOptionDefinition
     */
    public function setRoomCount($roomCount = null)
    {
        // validation for constraint: int
        if (!is_null($roomCount) && !is_numeric($roomCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($roomCount)), __LINE__);
        }
        $this->RoomCount = $roomCount;
        return $this;
    }
    /**
     * Get RoomType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RoomTypeDefinition|null
     */
    public function getRoomType()
    {
        return isset($this->RoomType) ? $this->RoomType : null;
    }
    /**
     * Set RoomType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RoomTypeDefinition $roomType
     * @return \StructType\RoomOptionDefinition
     */
    public function setRoomType(\StructType\RoomTypeDefinition $roomType = null)
    {
        if (is_null($roomType) || (is_array($roomType) && empty($roomType))) {
            unset($this->RoomType);
        } else {
            $this->RoomType = $roomType;
        }
        return $this;
    }
    /**
     * Get Supplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProviderInfoDefinition|null
     */
    public function getSupplier()
    {
        return isset($this->Supplier) ? $this->Supplier : null;
    }
    /**
     * Set Supplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProviderInfoDefinition $supplier
     * @return \StructType\RoomOptionDefinition
     */
    public function setSupplier(\StructType\ProviderInfoDefinition $supplier = null)
    {
        if (is_null($supplier) || (is_array($supplier) && empty($supplier))) {
            unset($this->Supplier);
        } else {
            $this->Supplier = $supplier;
        }
        return $this;
    }
    /**
     * Get TTL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTTL()
    {
        return isset($this->TTL) ? $this->TTL : null;
    }
    /**
     * Set TTL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tTL
     * @return \StructType\RoomOptionDefinition
     */
    public function setTTL($tTL = null)
    {
        // validation for constraint: string
        if (!is_null($tTL) && !is_string($tTL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tTL)), __LINE__);
        }
        if (is_null($tTL) || (is_array($tTL) && empty($tTL))) {
            unset($this->TTL);
        } else {
            $this->TTL = $tTL;
        }
        return $this;
    }
    /**
     * Get TransactionToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionToken()
    {
        return isset($this->TransactionToken) ? $this->TransactionToken : null;
    }
    /**
     * Set TransactionToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionToken
     * @return \StructType\RoomOptionDefinition
     */
    public function setTransactionToken($transactionToken = null)
    {
        // validation for constraint: string
        if (!is_null($transactionToken) && !is_string($transactionToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionToken)), __LINE__);
        }
        if (is_null($transactionToken) || (is_array($transactionToken) && empty($transactionToken))) {
            unset($this->TransactionToken);
        } else {
            $this->TransactionToken = $transactionToken;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomOptionDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
