<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestSettingsDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RequestSettingsDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class RequestSettingsDefinition extends AbstractStructBase
{
    /**
     * The BranchCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BranchCode;
    /**
     * The BusinessUnitCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessUnitCode;
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClientIdentifierDefinition
     */
    public $Client;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MaxResults
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxResults;
    /**
     * The RequestSettingsContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RequestSettingsContextDefinition
     */
    public $RequestSettingsContext;
    /**
     * The SaleType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SaleType;
    /**
     * The SalesChanelCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesChanelCode;
    /**
     * Constructor method for RequestSettingsDefinition
     * @uses RequestSettingsDefinition::setBranchCode()
     * @uses RequestSettingsDefinition::setBusinessUnitCode()
     * @uses RequestSettingsDefinition::setClient()
     * @uses RequestSettingsDefinition::setCurrencyCode()
     * @uses RequestSettingsDefinition::setMaxResults()
     * @uses RequestSettingsDefinition::setRequestSettingsContext()
     * @uses RequestSettingsDefinition::setSaleType()
     * @uses RequestSettingsDefinition::setSalesChanelCode()
     * @param string $branchCode
     * @param string $businessUnitCode
     * @param \StructType\ClientIdentifierDefinition $client
     * @param string $currencyCode
     * @param int $maxResults
     * @param \StructType\RequestSettingsContextDefinition $requestSettingsContext
     * @param string $saleType
     * @param string $salesChanelCode
     */
    public function __construct($branchCode = null, $businessUnitCode = null, \StructType\ClientIdentifierDefinition $client = null, $currencyCode = null, $maxResults = null, \StructType\RequestSettingsContextDefinition $requestSettingsContext = null, $saleType = null, $salesChanelCode = null)
    {
        $this
            ->setBranchCode($branchCode)
            ->setBusinessUnitCode($businessUnitCode)
            ->setClient($client)
            ->setCurrencyCode($currencyCode)
            ->setMaxResults($maxResults)
            ->setRequestSettingsContext($requestSettingsContext)
            ->setSaleType($saleType)
            ->setSalesChanelCode($salesChanelCode);
    }
    /**
     * Get BranchCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBranchCode()
    {
        return isset($this->BranchCode) ? $this->BranchCode : null;
    }
    /**
     * Set BranchCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $branchCode
     * @return \StructType\RequestSettingsDefinition
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($branchCode)), __LINE__);
        }
        if (is_null($branchCode) || (is_array($branchCode) && empty($branchCode))) {
            unset($this->BranchCode);
        } else {
            $this->BranchCode = $branchCode;
        }
        return $this;
    }
    /**
     * Get BusinessUnitCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessUnitCode()
    {
        return isset($this->BusinessUnitCode) ? $this->BusinessUnitCode : null;
    }
    /**
     * Set BusinessUnitCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessUnitCode
     * @return \StructType\RequestSettingsDefinition
     */
    public function setBusinessUnitCode($businessUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($businessUnitCode) && !is_string($businessUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessUnitCode)), __LINE__);
        }
        if (is_null($businessUnitCode) || (is_array($businessUnitCode) && empty($businessUnitCode))) {
            unset($this->BusinessUnitCode);
        } else {
            $this->BusinessUnitCode = $businessUnitCode;
        }
        return $this;
    }
    /**
     * Get Client value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClientIdentifierDefinition|null
     */
    public function getClient()
    {
        return isset($this->Client) ? $this->Client : null;
    }
    /**
     * Set Client value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ClientIdentifierDefinition $client
     * @return \StructType\RequestSettingsDefinition
     */
    public function setClient(\StructType\ClientIdentifierDefinition $client = null)
    {
        if (is_null($client) || (is_array($client) && empty($client))) {
            unset($this->Client);
        } else {
            $this->Client = $client;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\RequestSettingsDefinition
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get MaxResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxResults()
    {
        return isset($this->MaxResults) ? $this->MaxResults : null;
    }
    /**
     * Set MaxResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxResults
     * @return \StructType\RequestSettingsDefinition
     */
    public function setMaxResults($maxResults = null)
    {
        // validation for constraint: int
        if (!is_null($maxResults) && !is_numeric($maxResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxResults)), __LINE__);
        }
        if (is_null($maxResults) || (is_array($maxResults) && empty($maxResults))) {
            unset($this->MaxResults);
        } else {
            $this->MaxResults = $maxResults;
        }
        return $this;
    }
    /**
     * Get RequestSettingsContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RequestSettingsContextDefinition|null
     */
    public function getRequestSettingsContext()
    {
        return isset($this->RequestSettingsContext) ? $this->RequestSettingsContext : null;
    }
    /**
     * Set RequestSettingsContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RequestSettingsContextDefinition $requestSettingsContext
     * @return \StructType\RequestSettingsDefinition
     */
    public function setRequestSettingsContext(\StructType\RequestSettingsContextDefinition $requestSettingsContext = null)
    {
        if (is_null($requestSettingsContext) || (is_array($requestSettingsContext) && empty($requestSettingsContext))) {
            unset($this->RequestSettingsContext);
        } else {
            $this->RequestSettingsContext = $requestSettingsContext;
        }
        return $this;
    }
    /**
     * Get SaleType value
     * @return string|null
     */
    public function getSaleType()
    {
        return $this->SaleType;
    }
    /**
     * Set SaleType value
     * @uses \EnumType\SaleType::valueIsValid()
     * @uses \EnumType\SaleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $saleType
     * @return \StructType\RequestSettingsDefinition
     */
    public function setSaleType($saleType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SaleType::valueIsValid($saleType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $saleType, implode(', ', \EnumType\SaleType::getValidValues())), __LINE__);
        }
        $this->SaleType = $saleType;
        return $this;
    }
    /**
     * Get SalesChanelCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesChanelCode()
    {
        return isset($this->SalesChanelCode) ? $this->SalesChanelCode : null;
    }
    /**
     * Set SalesChanelCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesChanelCode
     * @return \StructType\RequestSettingsDefinition
     */
    public function setSalesChanelCode($salesChanelCode = null)
    {
        // validation for constraint: string
        if (!is_null($salesChanelCode) && !is_string($salesChanelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesChanelCode)), __LINE__);
        }
        if (is_null($salesChanelCode) || (is_array($salesChanelCode) && empty($salesChanelCode))) {
            unset($this->SalesChanelCode);
        } else {
            $this->SalesChanelCode = $salesChanelCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestSettingsDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
