<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileCardDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileCardDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfileCardDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The Bank
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProfileBankDefinition
     */
    public $Bank;
    /**
     * The CardHolderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardHolderName;
    /**
     * The CardId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardId;
    /**
     * The CardNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProfileCardTypeDefinition
     */
    public $CardType;
    /**
     * The ExpirationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The IsDefault
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDefault;
    /**
     * The ProfileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileId;
    /**
     * The SecurityCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecurityCode;
    /**
     * Constructor method for ProfileCardDefinition
     * @uses ProfileCardDefinition::setActionType()
     * @uses ProfileCardDefinition::setBank()
     * @uses ProfileCardDefinition::setCardHolderName()
     * @uses ProfileCardDefinition::setCardId()
     * @uses ProfileCardDefinition::setCardNumber()
     * @uses ProfileCardDefinition::setCardType()
     * @uses ProfileCardDefinition::setExpirationDate()
     * @uses ProfileCardDefinition::setIsDefault()
     * @uses ProfileCardDefinition::setProfileId()
     * @uses ProfileCardDefinition::setSecurityCode()
     * @param string $actionType
     * @param \StructType\ProfileBankDefinition $bank
     * @param string $cardHolderName
     * @param int $cardId
     * @param string $cardNumber
     * @param \StructType\ProfileCardTypeDefinition $cardType
     * @param string $expirationDate
     * @param bool $isDefault
     * @param int $profileId
     * @param string $securityCode
     */
    public function __construct($actionType = null, \StructType\ProfileBankDefinition $bank = null, $cardHolderName = null, $cardId = null, $cardNumber = null, \StructType\ProfileCardTypeDefinition $cardType = null, $expirationDate = null, $isDefault = null, $profileId = null, $securityCode = null)
    {
        $this
            ->setActionType($actionType)
            ->setBank($bank)
            ->setCardHolderName($cardHolderName)
            ->setCardId($cardId)
            ->setCardNumber($cardNumber)
            ->setCardType($cardType)
            ->setExpirationDate($expirationDate)
            ->setIsDefault($isDefault)
            ->setProfileId($profileId)
            ->setSecurityCode($securityCode);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ProfileCardDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get Bank value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProfileBankDefinition|null
     */
    public function getBank()
    {
        return isset($this->Bank) ? $this->Bank : null;
    }
    /**
     * Set Bank value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProfileBankDefinition $bank
     * @return \StructType\ProfileCardDefinition
     */
    public function setBank(\StructType\ProfileBankDefinition $bank = null)
    {
        if (is_null($bank) || (is_array($bank) && empty($bank))) {
            unset($this->Bank);
        } else {
            $this->Bank = $bank;
        }
        return $this;
    }
    /**
     * Get CardHolderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardHolderName()
    {
        return isset($this->CardHolderName) ? $this->CardHolderName : null;
    }
    /**
     * Set CardHolderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardHolderName
     * @return \StructType\ProfileCardDefinition
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardHolderName)), __LINE__);
        }
        if (is_null($cardHolderName) || (is_array($cardHolderName) && empty($cardHolderName))) {
            unset($this->CardHolderName);
        } else {
            $this->CardHolderName = $cardHolderName;
        }
        return $this;
    }
    /**
     * Get CardId value
     * @return int|null
     */
    public function getCardId()
    {
        return $this->CardId;
    }
    /**
     * Set CardId value
     * @param int $cardId
     * @return \StructType\ProfileCardDefinition
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: int
        if (!is_null($cardId) && !is_numeric($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cardId)), __LINE__);
        }
        $this->CardId = $cardId;
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \StructType\ProfileCardDefinition
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProfileCardTypeDefinition|null
     */
    public function getCardType()
    {
        return isset($this->CardType) ? $this->CardType : null;
    }
    /**
     * Set CardType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProfileCardTypeDefinition $cardType
     * @return \StructType\ProfileCardDefinition
     */
    public function setCardType(\StructType\ProfileCardTypeDefinition $cardType = null)
    {
        if (is_null($cardType) || (is_array($cardType) && empty($cardType))) {
            unset($this->CardType);
        } else {
            $this->CardType = $cardType;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\ProfileCardDefinition
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \StructType\ProfileCardDefinition
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDefault)), __LINE__);
        }
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get ProfileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\ProfileCardDefinition
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Get SecurityCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityCode()
    {
        return isset($this->SecurityCode) ? $this->SecurityCode : null;
    }
    /**
     * Set SecurityCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityCode
     * @return \StructType\ProfileCardDefinition
     */
    public function setSecurityCode($securityCode = null)
    {
        // validation for constraint: string
        if (!is_null($securityCode) && !is_string($securityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityCode)), __LINE__);
        }
        if (is_null($securityCode) || (is_array($securityCode) && empty($securityCode))) {
            unset($this->SecurityCode);
        } else {
            $this->SecurityCode = $securityCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileCardDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
