<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductFeeDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductFeeDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProductFeeDefinition extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PercentageAmountDefinition
     */
    public $Amount;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The FeeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FeeType;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * Constructor method for ProductFeeDefinition
     * @uses ProductFeeDefinition::setAmount()
     * @uses ProductFeeDefinition::setCode()
     * @uses ProductFeeDefinition::setFeeType()
     * @uses ProductFeeDefinition::setId()
     * @param \StructType\PercentageAmountDefinition $amount
     * @param string $code
     * @param string $feeType
     * @param int $id
     */
    public function __construct(\StructType\PercentageAmountDefinition $amount = null, $code = null, $feeType = null, $id = null)
    {
        $this
            ->setAmount($amount)
            ->setCode($code)
            ->setFeeType($feeType)
            ->setId($id);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PercentageAmountDefinition|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PercentageAmountDefinition $amount
     * @return \StructType\ProductFeeDefinition
     */
    public function setAmount(\StructType\PercentageAmountDefinition $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\ProductFeeDefinition
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get FeeType value
     * @return string|null
     */
    public function getFeeType()
    {
        return $this->FeeType;
    }
    /**
     * Set FeeType value
     * @uses \EnumType\FeeType::valueIsValid()
     * @uses \EnumType\FeeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $feeType
     * @return \StructType\ProductFeeDefinition
     */
    public function setFeeType($feeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FeeType::valueIsValid($feeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $feeType, implode(', ', \EnumType\FeeType::getValidValues())), __LINE__);
        }
        $this->FeeType = $feeType;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ProductFeeDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductFeeDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
