<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservationResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelReservationResponse
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class HotelReservationResponse extends AbstractStructBase
{
    /**
     * The HotelInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelInformationDefinition
     */
    public $HotelInfo;
    /**
     * The HotelRoomBooking
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelRoomBookingDefinition
     */
    public $HotelRoomBooking;
    /**
     * The HotelRoomBookings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHotelRoomBookingDefinition
     */
    public $HotelRoomBookings;
    /**
     * Constructor method for HotelReservationResponse
     * @uses HotelReservationResponse::setHotelInfo()
     * @uses HotelReservationResponse::setHotelRoomBooking()
     * @uses HotelReservationResponse::setHotelRoomBookings()
     * @param \StructType\HotelInformationDefinition $hotelInfo
     * @param \StructType\HotelRoomBookingDefinition $hotelRoomBooking
     * @param \ArrayType\ArrayOfHotelRoomBookingDefinition $hotelRoomBookings
     */
    public function __construct(\StructType\HotelInformationDefinition $hotelInfo = null, \StructType\HotelRoomBookingDefinition $hotelRoomBooking = null, \ArrayType\ArrayOfHotelRoomBookingDefinition $hotelRoomBookings = null)
    {
        $this
            ->setHotelInfo($hotelInfo)
            ->setHotelRoomBooking($hotelRoomBooking)
            ->setHotelRoomBookings($hotelRoomBookings);
    }
    /**
     * Get HotelInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelInformationDefinition|null
     */
    public function getHotelInfo()
    {
        return isset($this->HotelInfo) ? $this->HotelInfo : null;
    }
    /**
     * Set HotelInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelInformationDefinition $hotelInfo
     * @return \StructType\HotelReservationResponse
     */
    public function setHotelInfo(\StructType\HotelInformationDefinition $hotelInfo = null)
    {
        if (is_null($hotelInfo) || (is_array($hotelInfo) && empty($hotelInfo))) {
            unset($this->HotelInfo);
        } else {
            $this->HotelInfo = $hotelInfo;
        }
        return $this;
    }
    /**
     * Get HotelRoomBooking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelRoomBookingDefinition|null
     */
    public function getHotelRoomBooking()
    {
        return isset($this->HotelRoomBooking) ? $this->HotelRoomBooking : null;
    }
    /**
     * Set HotelRoomBooking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelRoomBookingDefinition $hotelRoomBooking
     * @return \StructType\HotelReservationResponse
     */
    public function setHotelRoomBooking(\StructType\HotelRoomBookingDefinition $hotelRoomBooking = null)
    {
        if (is_null($hotelRoomBooking) || (is_array($hotelRoomBooking) && empty($hotelRoomBooking))) {
            unset($this->HotelRoomBooking);
        } else {
            $this->HotelRoomBooking = $hotelRoomBooking;
        }
        return $this;
    }
    /**
     * Get HotelRoomBookings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHotelRoomBookingDefinition|null
     */
    public function getHotelRoomBookings()
    {
        return isset($this->HotelRoomBookings) ? $this->HotelRoomBookings : null;
    }
    /**
     * Set HotelRoomBookings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHotelRoomBookingDefinition $hotelRoomBookings
     * @return \StructType\HotelReservationResponse
     */
    public function setHotelRoomBookings(\ArrayType\ArrayOfHotelRoomBookingDefinition $hotelRoomBookings = null)
    {
        if (is_null($hotelRoomBookings) || (is_array($hotelRoomBookings) && empty($hotelRoomBookings))) {
            unset($this->HotelRoomBookings);
        } else {
            $this->HotelRoomBookings = $hotelRoomBookings;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelReservationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
