<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityChangesHistoryDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EntityChangesHistoryDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class EntityChangesHistoryDefinition extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The ChangeDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ChangeDateTime;
    /**
     * The EntityChangesHistoryDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEntityChangesHistoryDetailDefinition
     */
    public $EntityChangesHistoryDetails;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * Constructor method for EntityChangesHistoryDefinition
     * @uses EntityChangesHistoryDefinition::setAction()
     * @uses EntityChangesHistoryDefinition::setChangeDateTime()
     * @uses EntityChangesHistoryDefinition::setEntityChangesHistoryDetails()
     * @uses EntityChangesHistoryDefinition::setUsername()
     * @param string $action
     * @param string $changeDateTime
     * @param \ArrayType\ArrayOfEntityChangesHistoryDetailDefinition $entityChangesHistoryDetails
     * @param string $username
     */
    public function __construct($action = null, $changeDateTime = null, \ArrayType\ArrayOfEntityChangesHistoryDetailDefinition $entityChangesHistoryDetails = null, $username = null)
    {
        $this
            ->setAction($action)
            ->setChangeDateTime($changeDateTime)
            ->setEntityChangesHistoryDetails($entityChangesHistoryDetails)
            ->setUsername($username);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $action
     * @return \StructType\EntityChangesHistoryDefinition
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($action)), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get ChangeDateTime value
     * @return string|null
     */
    public function getChangeDateTime()
    {
        return $this->ChangeDateTime;
    }
    /**
     * Set ChangeDateTime value
     * @param string $changeDateTime
     * @return \StructType\EntityChangesHistoryDefinition
     */
    public function setChangeDateTime($changeDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($changeDateTime) && !is_string($changeDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changeDateTime)), __LINE__);
        }
        $this->ChangeDateTime = $changeDateTime;
        return $this;
    }
    /**
     * Get EntityChangesHistoryDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEntityChangesHistoryDetailDefinition|null
     */
    public function getEntityChangesHistoryDetails()
    {
        return isset($this->EntityChangesHistoryDetails) ? $this->EntityChangesHistoryDetails : null;
    }
    /**
     * Set EntityChangesHistoryDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEntityChangesHistoryDetailDefinition $entityChangesHistoryDetails
     * @return \StructType\EntityChangesHistoryDefinition
     */
    public function setEntityChangesHistoryDetails(\ArrayType\ArrayOfEntityChangesHistoryDetailDefinition $entityChangesHistoryDetails = null)
    {
        if (is_null($entityChangesHistoryDetails) || (is_array($entityChangesHistoryDetails) && empty($entityChangesHistoryDetails))) {
            unset($this->EntityChangesHistoryDetails);
        } else {
            $this->EntityChangesHistoryDetails = $entityChangesHistoryDetails;
        }
        return $this;
    }
    /**
     * Get Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->Username) ? $this->Username : null;
    }
    /**
     * Set Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\EntityChangesHistoryDefinition
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->Username);
        } else {
            $this->Username = $username;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntityChangesHistoryDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
