<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CasesHistoryDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CasesHistoryDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class CasesHistoryDefinition extends ClientHistoryDefinition
{
    /**
     * The AttendedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttendedBy;
    /**
     * The IsAdmin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAdmin;
    /**
     * The LastComment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastComment;
    /**
     * The LoginId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LoginId;
    /**
     * The RowNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RowNumber;
    /**
     * Constructor method for CasesHistoryDefinition
     * @uses CasesHistoryDefinition::setAttendedBy()
     * @uses CasesHistoryDefinition::setIsAdmin()
     * @uses CasesHistoryDefinition::setLastComment()
     * @uses CasesHistoryDefinition::setLoginId()
     * @uses CasesHistoryDefinition::setRowNumber()
     * @param string $attendedBy
     * @param bool $isAdmin
     * @param string $lastComment
     * @param int $loginId
     * @param int $rowNumber
     */
    public function __construct($attendedBy = null, $isAdmin = null, $lastComment = null, $loginId = null, $rowNumber = null)
    {
        $this
            ->setAttendedBy($attendedBy)
            ->setIsAdmin($isAdmin)
            ->setLastComment($lastComment)
            ->setLoginId($loginId)
            ->setRowNumber($rowNumber);
    }
    /**
     * Get AttendedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttendedBy()
    {
        return isset($this->AttendedBy) ? $this->AttendedBy : null;
    }
    /**
     * Set AttendedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attendedBy
     * @return \StructType\CasesHistoryDefinition
     */
    public function setAttendedBy($attendedBy = null)
    {
        // validation for constraint: string
        if (!is_null($attendedBy) && !is_string($attendedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attendedBy)), __LINE__);
        }
        if (is_null($attendedBy) || (is_array($attendedBy) && empty($attendedBy))) {
            unset($this->AttendedBy);
        } else {
            $this->AttendedBy = $attendedBy;
        }
        return $this;
    }
    /**
     * Get IsAdmin value
     * @return bool|null
     */
    public function getIsAdmin()
    {
        return $this->IsAdmin;
    }
    /**
     * Set IsAdmin value
     * @param bool $isAdmin
     * @return \StructType\CasesHistoryDefinition
     */
    public function setIsAdmin($isAdmin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAdmin) && !is_bool($isAdmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAdmin)), __LINE__);
        }
        $this->IsAdmin = $isAdmin;
        return $this;
    }
    /**
     * Get LastComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastComment()
    {
        return isset($this->LastComment) ? $this->LastComment : null;
    }
    /**
     * Set LastComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastComment
     * @return \StructType\CasesHistoryDefinition
     */
    public function setLastComment($lastComment = null)
    {
        // validation for constraint: string
        if (!is_null($lastComment) && !is_string($lastComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastComment)), __LINE__);
        }
        if (is_null($lastComment) || (is_array($lastComment) && empty($lastComment))) {
            unset($this->LastComment);
        } else {
            $this->LastComment = $lastComment;
        }
        return $this;
    }
    /**
     * Get LoginId value
     * @return int|null
     */
    public function getLoginId()
    {
        return $this->LoginId;
    }
    /**
     * Set LoginId value
     * @param int $loginId
     * @return \StructType\CasesHistoryDefinition
     */
    public function setLoginId($loginId = null)
    {
        // validation for constraint: int
        if (!is_null($loginId) && !is_numeric($loginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($loginId)), __LINE__);
        }
        $this->LoginId = $loginId;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\CasesHistoryDefinition
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !is_numeric($rowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CasesHistoryDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
