<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTicketDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AirTicketDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class AirTicketDefinition extends AbstractStructBase
{
    /**
     * The CashAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CashAmount;
    /**
     * The ConjuntionTktNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ConjuntionTktNumber;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameNumber;
    /**
     * The OverCommission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OverCommission;
    /**
     * The OverFareId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OverFareId;
    /**
     * The PassengerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PassengerId;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PassengerType;
    /**
     * The PaymentFormType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentFormType;
    /**
     * The StandardCommission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $StandardCommission;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketNumber;
    /**
     * The TourCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TourCode;
    /**
     * Constructor method for AirTicketDefinition
     * @uses AirTicketDefinition::setCashAmount()
     * @uses AirTicketDefinition::setConjuntionTktNumber()
     * @uses AirTicketDefinition::setId()
     * @uses AirTicketDefinition::setNameNumber()
     * @uses AirTicketDefinition::setOverCommission()
     * @uses AirTicketDefinition::setOverFareId()
     * @uses AirTicketDefinition::setPassengerId()
     * @uses AirTicketDefinition::setPassengerType()
     * @uses AirTicketDefinition::setPaymentFormType()
     * @uses AirTicketDefinition::setStandardCommission()
     * @uses AirTicketDefinition::setTicketNumber()
     * @uses AirTicketDefinition::setTourCode()
     * @param float $cashAmount
     * @param int $conjuntionTktNumber
     * @param int $id
     * @param string $nameNumber
     * @param float $overCommission
     * @param int $overFareId
     * @param int $passengerId
     * @param string $passengerType
     * @param string $paymentFormType
     * @param float $standardCommission
     * @param string $ticketNumber
     * @param string $tourCode
     */
    public function __construct($cashAmount = null, $conjuntionTktNumber = null, $id = null, $nameNumber = null, $overCommission = null, $overFareId = null, $passengerId = null, $passengerType = null, $paymentFormType = null, $standardCommission = null, $ticketNumber = null, $tourCode = null)
    {
        $this
            ->setCashAmount($cashAmount)
            ->setConjuntionTktNumber($conjuntionTktNumber)
            ->setId($id)
            ->setNameNumber($nameNumber)
            ->setOverCommission($overCommission)
            ->setOverFareId($overFareId)
            ->setPassengerId($passengerId)
            ->setPassengerType($passengerType)
            ->setPaymentFormType($paymentFormType)
            ->setStandardCommission($standardCommission)
            ->setTicketNumber($ticketNumber)
            ->setTourCode($tourCode);
    }
    /**
     * Get CashAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCashAmount()
    {
        return isset($this->CashAmount) ? $this->CashAmount : null;
    }
    /**
     * Set CashAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cashAmount
     * @return \StructType\AirTicketDefinition
     */
    public function setCashAmount($cashAmount = null)
    {
        if (is_null($cashAmount) || (is_array($cashAmount) && empty($cashAmount))) {
            unset($this->CashAmount);
        } else {
            $this->CashAmount = $cashAmount;
        }
        return $this;
    }
    /**
     * Get ConjuntionTktNumber value
     * @return int|null
     */
    public function getConjuntionTktNumber()
    {
        return $this->ConjuntionTktNumber;
    }
    /**
     * Set ConjuntionTktNumber value
     * @param int $conjuntionTktNumber
     * @return \StructType\AirTicketDefinition
     */
    public function setConjuntionTktNumber($conjuntionTktNumber = null)
    {
        // validation for constraint: int
        if (!is_null($conjuntionTktNumber) && !is_numeric($conjuntionTktNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($conjuntionTktNumber)), __LINE__);
        }
        $this->ConjuntionTktNumber = $conjuntionTktNumber;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\AirTicketDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get NameNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameNumber()
    {
        return isset($this->NameNumber) ? $this->NameNumber : null;
    }
    /**
     * Set NameNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameNumber
     * @return \StructType\AirTicketDefinition
     */
    public function setNameNumber($nameNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nameNumber) && !is_string($nameNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameNumber)), __LINE__);
        }
        if (is_null($nameNumber) || (is_array($nameNumber) && empty($nameNumber))) {
            unset($this->NameNumber);
        } else {
            $this->NameNumber = $nameNumber;
        }
        return $this;
    }
    /**
     * Get OverCommission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOverCommission()
    {
        return isset($this->OverCommission) ? $this->OverCommission : null;
    }
    /**
     * Set OverCommission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $overCommission
     * @return \StructType\AirTicketDefinition
     */
    public function setOverCommission($overCommission = null)
    {
        if (is_null($overCommission) || (is_array($overCommission) && empty($overCommission))) {
            unset($this->OverCommission);
        } else {
            $this->OverCommission = $overCommission;
        }
        return $this;
    }
    /**
     * Get OverFareId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOverFareId()
    {
        return isset($this->OverFareId) ? $this->OverFareId : null;
    }
    /**
     * Set OverFareId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $overFareId
     * @return \StructType\AirTicketDefinition
     */
    public function setOverFareId($overFareId = null)
    {
        // validation for constraint: int
        if (!is_null($overFareId) && !is_numeric($overFareId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($overFareId)), __LINE__);
        }
        if (is_null($overFareId) || (is_array($overFareId) && empty($overFareId))) {
            unset($this->OverFareId);
        } else {
            $this->OverFareId = $overFareId;
        }
        return $this;
    }
    /**
     * Get PassengerId value
     * @return int|null
     */
    public function getPassengerId()
    {
        return $this->PassengerId;
    }
    /**
     * Set PassengerId value
     * @param int $passengerId
     * @return \StructType\AirTicketDefinition
     */
    public function setPassengerId($passengerId = null)
    {
        // validation for constraint: int
        if (!is_null($passengerId) && !is_numeric($passengerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($passengerId)), __LINE__);
        }
        $this->PassengerId = $passengerId;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @uses \EnumType\PassengerType::valueIsValid()
     * @uses \EnumType\PassengerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $passengerType
     * @return \StructType\AirTicketDefinition
     */
    public function setPassengerType($passengerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PassengerType::valueIsValid($passengerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $passengerType, implode(', ', \EnumType\PassengerType::getValidValues())), __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get PaymentFormType value
     * @return string|null
     */
    public function getPaymentFormType()
    {
        return $this->PaymentFormType;
    }
    /**
     * Set PaymentFormType value
     * @uses \EnumType\PaymentFormType::valueIsValid()
     * @uses \EnumType\PaymentFormType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentFormType
     * @return \StructType\AirTicketDefinition
     */
    public function setPaymentFormType($paymentFormType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentFormType::valueIsValid($paymentFormType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentFormType, implode(', ', \EnumType\PaymentFormType::getValidValues())), __LINE__);
        }
        $this->PaymentFormType = $paymentFormType;
        return $this;
    }
    /**
     * Get StandardCommission value
     * @return float|null
     */
    public function getStandardCommission()
    {
        return $this->StandardCommission;
    }
    /**
     * Set StandardCommission value
     * @param float $standardCommission
     * @return \StructType\AirTicketDefinition
     */
    public function setStandardCommission($standardCommission = null)
    {
        $this->StandardCommission = $standardCommission;
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketNumber
     * @return \StructType\AirTicketDefinition
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get TourCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTourCode()
    {
        return isset($this->TourCode) ? $this->TourCode : null;
    }
    /**
     * Set TourCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tourCode
     * @return \StructType\AirTicketDefinition
     */
    public function setTourCode($tourCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourCode) && !is_string($tourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tourCode)), __LINE__);
        }
        if (is_null($tourCode) || (is_array($tourCode) && empty($tourCode))) {
            unset($this->TourCode);
        } else {
            $this->TourCode = $tourCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirTicketDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
