<?php

namespace EnumType;

/**
 * This class stands for InventorySourceType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:InventorySourceType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class InventorySourceType
{
    /**
     * Constant for value 'OnRequest'
     * @return string 'OnRequest'
     */
    const VALUE_ON_REQUEST = 'OnRequest';
    /**
     * Constant for value 'FreeSale'
     * @return string 'FreeSale'
     */
    const VALUE_FREE_SALE = 'FreeSale';
    /**
     * Constant for value 'Inventory'
     * @return string 'Inventory'
     */
    const VALUE_INVENTORY = 'Inventory';
    /**
     * Constant for value 'DirectConnect'
     * @return string 'DirectConnect'
     */
    const VALUE_DIRECT_CONNECT = 'DirectConnect';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ON_REQUEST
     * @uses self::VALUE_FREE_SALE
     * @uses self::VALUE_INVENTORY
     * @uses self::VALUE_DIRECT_CONNECT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ON_REQUEST,
            self::VALUE_FREE_SALE,
            self::VALUE_INVENTORY,
            self::VALUE_DIRECT_CONNECT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
