<?php

namespace EnumType;

/**
 * This class stands for DepositInfoTimeUnitType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DepositInfoTimeUnitType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class DepositInfoTimeUnitType
{
    /**
     * Constant for value 'Days'
     * @return string 'Days'
     */
    const VALUE_DAYS = 'Days';
    /**
     * Constant for value 'Hours'
     * @return string 'Hours'
     */
    const VALUE_HOURS = 'Hours';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DAYS
     * @uses self::VALUE_HOURS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DAYS,
            self::VALUE_HOURS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
