<?php

namespace EnumType;

/**
 * This class stands for DepositInfoReferencePointType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DepositInfoReferencePointType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class DepositInfoReferencePointType
{
    /**
     * Constant for value 'AfterReservation'
     * @return string 'AfterReservation'
     */
    const VALUE_AFTER_RESERVATION = 'AfterReservation';
    /**
     * Constant for value 'BeforeUse'
     * @return string 'BeforeUse'
     */
    const VALUE_BEFORE_USE = 'BeforeUse';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AFTER_RESERVATION
     * @uses self::VALUE_BEFORE_USE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AFTER_RESERVATION,
            self::VALUE_BEFORE_USE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
