<?php

namespace EnumType;

/**
 * This class stands for CostType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CostType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class CostType
{
    /**
     * Constant for value 'Commissionable'
     * @return string 'Commissionable'
     */
    const VALUE_COMMISSIONABLE = 'Commissionable';
    /**
     * Constant for value 'OverCommission'
     * @return string 'OverCommission'
     */
    const VALUE_OVER_COMMISSION = 'OverCommission';
    /**
     * Constant for value 'Net'
     * @return string 'Net'
     */
    const VALUE_NET = 'Net';
    /**
     * Constant for value 'BuySell'
     * @return string 'BuySell'
     */
    const VALUE_BUY_SELL = 'BuySell';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMMISSIONABLE
     * @uses self::VALUE_OVER_COMMISSION
     * @uses self::VALUE_NET
     * @uses self::VALUE_BUY_SELL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMMISSIONABLE,
            self::VALUE_OVER_COMMISSION,
            self::VALUE_NET,
            self::VALUE_BUY_SELL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
