<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductFeeDefinition ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfProductFeeDefinition
 * @subpackage Arrays
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ArrayOfProductFeeDefinition extends AbstractStructArrayBase
{
    /**
     * The ProductFeeDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductFeeDefinition[]
     */
    public $ProductFeeDefinition;
    /**
     * Constructor method for ArrayOfProductFeeDefinition
     * @uses ArrayOfProductFeeDefinition::setProductFeeDefinition()
     * @param \StructType\ProductFeeDefinition[] $productFeeDefinition
     */
    public function __construct(array $productFeeDefinition = array())
    {
        $this
            ->setProductFeeDefinition($productFeeDefinition);
    }
    /**
     * Get ProductFeeDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductFeeDefinition[]|null
     */
    public function getProductFeeDefinition()
    {
        return isset($this->ProductFeeDefinition) ? $this->ProductFeeDefinition : null;
    }
    /**
     * Set ProductFeeDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductFeeDefinition[] $productFeeDefinition
     * @return \ArrayType\ArrayOfProductFeeDefinition
     */
    public function setProductFeeDefinition(array $productFeeDefinition = array())
    {
        foreach ($productFeeDefinition as $arrayOfProductFeeDefinitionProductFeeDefinitionItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductFeeDefinitionProductFeeDefinitionItem instanceof \StructType\ProductFeeDefinition) {
                throw new \InvalidArgumentException(sprintf('The ProductFeeDefinition property can only contain items of \StructType\ProductFeeDefinition, "%s" given', is_object($arrayOfProductFeeDefinitionProductFeeDefinitionItem) ? get_class($arrayOfProductFeeDefinitionProductFeeDefinitionItem) : gettype($arrayOfProductFeeDefinitionProductFeeDefinitionItem)), __LINE__);
            }
        }
        if (is_null($productFeeDefinition) || (is_array($productFeeDefinition) && empty($productFeeDefinition))) {
            unset($this->ProductFeeDefinition);
        } else {
            $this->ProductFeeDefinition = $productFeeDefinition;
        }
        return $this;
    }
    /**
     * Add item to ProductFeeDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductFeeDefinition $item
     * @return \ArrayType\ArrayOfProductFeeDefinition
     */
    public function addToProductFeeDefinition(\StructType\ProductFeeDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductFeeDefinition) {
            throw new \InvalidArgumentException(sprintf('The ProductFeeDefinition property can only contain items of \StructType\ProductFeeDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductFeeDefinition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductFeeDefinition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductFeeDefinition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductFeeDefinition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductFeeDefinition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductFeeDefinition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductFeeDefinition
     */
    public function getAttributeName()
    {
        return 'ProductFeeDefinition';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProductFeeDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
