<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductDefinition ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfProductDefinition
 * @subpackage Arrays
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ArrayOfProductDefinition extends AbstractStructArrayBase
{
    /**
     * The ProductDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductDefinition[]
     */
    public $ProductDefinition;
    /**
     * Constructor method for ArrayOfProductDefinition
     * @uses ArrayOfProductDefinition::setProductDefinition()
     * @param \StructType\ProductDefinition[] $productDefinition
     */
    public function __construct(array $productDefinition = array())
    {
        $this
            ->setProductDefinition($productDefinition);
    }
    /**
     * Get ProductDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductDefinition[]|null
     */
    public function getProductDefinition()
    {
        return isset($this->ProductDefinition) ? $this->ProductDefinition : null;
    }
    /**
     * Set ProductDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductDefinition[] $productDefinition
     * @return \ArrayType\ArrayOfProductDefinition
     */
    public function setProductDefinition(array $productDefinition = array())
    {
        foreach ($productDefinition as $arrayOfProductDefinitionProductDefinitionItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductDefinitionProductDefinitionItem instanceof \StructType\ProductDefinition) {
                throw new \InvalidArgumentException(sprintf('The ProductDefinition property can only contain items of \StructType\ProductDefinition, "%s" given', is_object($arrayOfProductDefinitionProductDefinitionItem) ? get_class($arrayOfProductDefinitionProductDefinitionItem) : gettype($arrayOfProductDefinitionProductDefinitionItem)), __LINE__);
            }
        }
        if (is_null($productDefinition) || (is_array($productDefinition) && empty($productDefinition))) {
            unset($this->ProductDefinition);
        } else {
            $this->ProductDefinition = $productDefinition;
        }
        return $this;
    }
    /**
     * Add item to ProductDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductDefinition $item
     * @return \ArrayType\ArrayOfProductDefinition
     */
    public function addToProductDefinition(\StructType\ProductDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductDefinition) {
            throw new \InvalidArgumentException(sprintf('The ProductDefinition property can only contain items of \StructType\ProductDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductDefinition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductDefinition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductDefinition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductDefinition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductDefinition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductDefinition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductDefinition
     */
    public function getAttributeName()
    {
        return 'ProductDefinition';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProductDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
