<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TerminalPreferencesDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TerminalPreferencesDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class TerminalPreferencesDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The TerminalPreferencesType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TerminalPreferencesType;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * Constructor method for TerminalPreferencesDefinition
     * @uses TerminalPreferencesDefinition::setActionType()
     * @uses TerminalPreferencesDefinition::setId()
     * @uses TerminalPreferencesDefinition::setTerminalPreferencesType()
     * @uses TerminalPreferencesDefinition::setValue()
     * @param string $actionType
     * @param int $id
     * @param string $terminalPreferencesType
     * @param string $value
     */
    public function __construct($actionType = null, $id = null, $terminalPreferencesType = null, $value = null)
    {
        $this
            ->setActionType($actionType)
            ->setId($id)
            ->setTerminalPreferencesType($terminalPreferencesType)
            ->setValue($value);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\TerminalPreferencesDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\TerminalPreferencesDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get TerminalPreferencesType value
     * @return string|null
     */
    public function getTerminalPreferencesType()
    {
        return $this->TerminalPreferencesType;
    }
    /**
     * Set TerminalPreferencesType value
     * @uses \EnumType\TerminalPreferencesType::valueIsValid()
     * @uses \EnumType\TerminalPreferencesType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $terminalPreferencesType
     * @return \StructType\TerminalPreferencesDefinition
     */
    public function setTerminalPreferencesType($terminalPreferencesType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TerminalPreferencesType::valueIsValid($terminalPreferencesType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $terminalPreferencesType, implode(', ', \EnumType\TerminalPreferencesType::getValidValues())), __LINE__);
        }
        $this->TerminalPreferencesType = $terminalPreferencesType;
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \StructType\TerminalPreferencesDefinition
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TerminalPreferencesDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
