<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TerminalCommandDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TerminalCommandDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class TerminalCommandDefinition extends AbstractStructBase
{
    /**
     * The Command
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Command;
    /**
     * The CommandType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommandType;
    /**
     * Constructor method for TerminalCommandDefinition
     * @uses TerminalCommandDefinition::setCommand()
     * @uses TerminalCommandDefinition::setCommandType()
     * @param string $command
     * @param string $commandType
     */
    public function __construct($command = null, $commandType = null)
    {
        $this
            ->setCommand($command)
            ->setCommandType($commandType);
    }
    /**
     * Get Command value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommand()
    {
        return isset($this->Command) ? $this->Command : null;
    }
    /**
     * Set Command value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $command
     * @return \StructType\TerminalCommandDefinition
     */
    public function setCommand($command = null)
    {
        // validation for constraint: string
        if (!is_null($command) && !is_string($command)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($command)), __LINE__);
        }
        if (is_null($command) || (is_array($command) && empty($command))) {
            unset($this->Command);
        } else {
            $this->Command = $command;
        }
        return $this;
    }
    /**
     * Get CommandType value
     * @return string|null
     */
    public function getCommandType()
    {
        return $this->CommandType;
    }
    /**
     * Set CommandType value
     * @uses \EnumType\TerminalCommandType::valueIsValid()
     * @uses \EnumType\TerminalCommandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $commandType
     * @return \StructType\TerminalCommandDefinition
     */
    public function setCommandType($commandType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TerminalCommandType::valueIsValid($commandType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $commandType, implode(', ', \EnumType\TerminalCommandType::getValidValues())), __LINE__);
        }
        $this->CommandType = $commandType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TerminalCommandDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
