<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationsDataHistoryDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationsDataHistoryDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ReservationsDataHistoryDefinition extends AbstractStructBase
{
    /**
     * The ArrivalDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalDate;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Destinations;
    /**
     * The FirstPassenger
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstPassenger;
    /**
     * The PassengerID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PassengerID;
    /**
     * The Provider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provider;
    /**
     * The ReservationItemType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReservationItemType;
    /**
     * Constructor method for ReservationsDataHistoryDefinition
     * @uses ReservationsDataHistoryDefinition::setArrivalDate()
     * @uses ReservationsDataHistoryDefinition::setDepartureDate()
     * @uses ReservationsDataHistoryDefinition::setDestinations()
     * @uses ReservationsDataHistoryDefinition::setFirstPassenger()
     * @uses ReservationsDataHistoryDefinition::setPassengerID()
     * @uses ReservationsDataHistoryDefinition::setProvider()
     * @uses ReservationsDataHistoryDefinition::setReservationItemType()
     * @param string $arrivalDate
     * @param string $departureDate
     * @param string $destinations
     * @param string $firstPassenger
     * @param int $passengerID
     * @param string $provider
     * @param string $reservationItemType
     */
    public function __construct($arrivalDate = null, $departureDate = null, $destinations = null, $firstPassenger = null, $passengerID = null, $provider = null, $reservationItemType = null)
    {
        $this
            ->setArrivalDate($arrivalDate)
            ->setDepartureDate($departureDate)
            ->setDestinations($destinations)
            ->setFirstPassenger($firstPassenger)
            ->setPassengerID($passengerID)
            ->setProvider($provider)
            ->setReservationItemType($reservationItemType);
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\ReservationsDataHistoryDefinition
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\ReservationsDataHistoryDefinition
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Destinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinations()
    {
        return isset($this->Destinations) ? $this->Destinations : null;
    }
    /**
     * Set Destinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinations
     * @return \StructType\ReservationsDataHistoryDefinition
     */
    public function setDestinations($destinations = null)
    {
        // validation for constraint: string
        if (!is_null($destinations) && !is_string($destinations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinations)), __LINE__);
        }
        if (is_null($destinations) || (is_array($destinations) && empty($destinations))) {
            unset($this->Destinations);
        } else {
            $this->Destinations = $destinations;
        }
        return $this;
    }
    /**
     * Get FirstPassenger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstPassenger()
    {
        return isset($this->FirstPassenger) ? $this->FirstPassenger : null;
    }
    /**
     * Set FirstPassenger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstPassenger
     * @return \StructType\ReservationsDataHistoryDefinition
     */
    public function setFirstPassenger($firstPassenger = null)
    {
        // validation for constraint: string
        if (!is_null($firstPassenger) && !is_string($firstPassenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstPassenger)), __LINE__);
        }
        if (is_null($firstPassenger) || (is_array($firstPassenger) && empty($firstPassenger))) {
            unset($this->FirstPassenger);
        } else {
            $this->FirstPassenger = $firstPassenger;
        }
        return $this;
    }
    /**
     * Get PassengerID value
     * @return int|null
     */
    public function getPassengerID()
    {
        return $this->PassengerID;
    }
    /**
     * Set PassengerID value
     * @param int $passengerID
     * @return \StructType\ReservationsDataHistoryDefinition
     */
    public function setPassengerID($passengerID = null)
    {
        // validation for constraint: int
        if (!is_null($passengerID) && !is_numeric($passengerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($passengerID)), __LINE__);
        }
        $this->PassengerID = $passengerID;
        return $this;
    }
    /**
     * Get Provider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvider()
    {
        return isset($this->Provider) ? $this->Provider : null;
    }
    /**
     * Set Provider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provider
     * @return \StructType\ReservationsDataHistoryDefinition
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provider)), __LINE__);
        }
        if (is_null($provider) || (is_array($provider) && empty($provider))) {
            unset($this->Provider);
        } else {
            $this->Provider = $provider;
        }
        return $this;
    }
    /**
     * Get ReservationItemType value
     * @return string|null
     */
    public function getReservationItemType()
    {
        return $this->ReservationItemType;
    }
    /**
     * Set ReservationItemType value
     * @uses \EnumType\ReservationItemType::valueIsValid()
     * @uses \EnumType\ReservationItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationItemType
     * @return \StructType\ReservationsDataHistoryDefinition
     */
    public function setReservationItemType($reservationItemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReservationItemType::valueIsValid($reservationItemType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reservationItemType, implode(', ', \EnumType\ReservationItemType::getValidValues())), __LINE__);
        }
        $this->ReservationItemType = $reservationItemType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReservationsDataHistoryDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
