<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationItemTravelerDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationItemTravelerDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ReservationItemTravelerDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The ReservationItemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReservationItemId;
    /**
     * The TravelPaxType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TravelPaxType;
    /**
     * The Traveler
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProfilePersonDefinition
     */
    public $Traveler;
    /**
     * Constructor method for ReservationItemTravelerDefinition
     * @uses ReservationItemTravelerDefinition::setActionType()
     * @uses ReservationItemTravelerDefinition::setId()
     * @uses ReservationItemTravelerDefinition::setReservationItemId()
     * @uses ReservationItemTravelerDefinition::setTravelPaxType()
     * @uses ReservationItemTravelerDefinition::setTraveler()
     * @param string $actionType
     * @param int $id
     * @param int $reservationItemId
     * @param string $travelPaxType
     * @param \StructType\ProfilePersonDefinition $traveler
     */
    public function __construct($actionType = null, $id = null, $reservationItemId = null, $travelPaxType = null, \StructType\ProfilePersonDefinition $traveler = null)
    {
        $this
            ->setActionType($actionType)
            ->setId($id)
            ->setReservationItemId($reservationItemId)
            ->setTravelPaxType($travelPaxType)
            ->setTraveler($traveler);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ReservationItemTravelerDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ReservationItemTravelerDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ReservationItemId value
     * @return int|null
     */
    public function getReservationItemId()
    {
        return $this->ReservationItemId;
    }
    /**
     * Set ReservationItemId value
     * @param int $reservationItemId
     * @return \StructType\ReservationItemTravelerDefinition
     */
    public function setReservationItemId($reservationItemId = null)
    {
        // validation for constraint: int
        if (!is_null($reservationItemId) && !is_numeric($reservationItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationItemId)), __LINE__);
        }
        $this->ReservationItemId = $reservationItemId;
        return $this;
    }
    /**
     * Get TravelPaxType value
     * @return string|null
     */
    public function getTravelPaxType()
    {
        return $this->TravelPaxType;
    }
    /**
     * Set TravelPaxType value
     * @uses \EnumType\TravelPaxType::valueIsValid()
     * @uses \EnumType\TravelPaxType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $travelPaxType
     * @return \StructType\ReservationItemTravelerDefinition
     */
    public function setTravelPaxType($travelPaxType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TravelPaxType::valueIsValid($travelPaxType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $travelPaxType, implode(', ', \EnumType\TravelPaxType::getValidValues())), __LINE__);
        }
        $this->TravelPaxType = $travelPaxType;
        return $this;
    }
    /**
     * Get Traveler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProfilePersonDefinition|null
     */
    public function getTraveler()
    {
        return isset($this->Traveler) ? $this->Traveler : null;
    }
    /**
     * Set Traveler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProfilePersonDefinition $traveler
     * @return \StructType\ReservationItemTravelerDefinition
     */
    public function setTraveler(\StructType\ProfilePersonDefinition $traveler = null)
    {
        if (is_null($traveler) || (is_array($traveler) && empty($traveler))) {
            unset($this->Traveler);
        } else {
            $this->Traveler = $traveler;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReservationItemTravelerDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
