<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestSettingsContextDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RequestSettingsContextDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class RequestSettingsContextDefinition extends AbstractStructBase
{
    /**
     * The ClientIp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientIp;
    /**
     * The SessionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SessionId;
    /**
     * The UserAgent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserAgent;
    /**
     * Constructor method for RequestSettingsContextDefinition
     * @uses RequestSettingsContextDefinition::setClientIp()
     * @uses RequestSettingsContextDefinition::setSessionId()
     * @uses RequestSettingsContextDefinition::setUserAgent()
     * @param string $clientIp
     * @param string $sessionId
     * @param string $userAgent
     */
    public function __construct($clientIp = null, $sessionId = null, $userAgent = null)
    {
        $this
            ->setClientIp($clientIp)
            ->setSessionId($sessionId)
            ->setUserAgent($userAgent);
    }
    /**
     * Get ClientIp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientIp()
    {
        return isset($this->ClientIp) ? $this->ClientIp : null;
    }
    /**
     * Set ClientIp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientIp
     * @return \StructType\RequestSettingsContextDefinition
     */
    public function setClientIp($clientIp = null)
    {
        // validation for constraint: string
        if (!is_null($clientIp) && !is_string($clientIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientIp)), __LINE__);
        }
        if (is_null($clientIp) || (is_array($clientIp) && empty($clientIp))) {
            unset($this->ClientIp);
        } else {
            $this->ClientIp = $clientIp;
        }
        return $this;
    }
    /**
     * Get SessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionId()
    {
        return isset($this->SessionId) ? $this->SessionId : null;
    }
    /**
     * Set SessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionId
     * @return \StructType\RequestSettingsContextDefinition
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        if (is_null($sessionId) || (is_array($sessionId) && empty($sessionId))) {
            unset($this->SessionId);
        } else {
            $this->SessionId = $sessionId;
        }
        return $this;
    }
    /**
     * Get UserAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserAgent()
    {
        return isset($this->UserAgent) ? $this->UserAgent : null;
    }
    /**
     * Set UserAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userAgent
     * @return \StructType\RequestSettingsContextDefinition
     */
    public function setUserAgent($userAgent = null)
    {
        // validation for constraint: string
        if (!is_null($userAgent) && !is_string($userAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userAgent)), __LINE__);
        }
        if (is_null($userAgent) || (is_array($userAgent) && empty($userAgent))) {
            unset($this->UserAgent);
        } else {
            $this->UserAgent = $userAgent;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestSettingsContextDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
