<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfilePersonDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfilePersonDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfilePersonDefinition extends ProfileBaseDefinition
{
    /**
     * The ActionTypeImage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionTypeImage;
    /**
     * The AuthorizationRequired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AuthorizationRequired;
    /**
     * The Birthday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Birthday;
    /**
     * The BusinessUnitId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BusinessUnitId;
    /**
     * The Company
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Company;
    /**
     * The CompanyJob
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyJob;
    /**
     * The CompanySector
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanySector;
    /**
     * The DKNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DKNumber;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The GenderId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GenderId;
    /**
     * The HideCosts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HideCosts;
    /**
     * The Image
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProfileImageDefinition
     */
    public $Image;
    /**
     * The IsAdmin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAdmin;
    /**
     * The IsAgent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAgent;
    /**
     * The IsAuthorizer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAuthorizer;
    /**
     * The IsPassenger
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPassenger;
    /**
     * The JobTitle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JobTitle;
    /**
     * The LanguageId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LanguageId;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MaritalStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaritalStatus;
    /**
     * The Nationality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nationality;
    /**
     * The PrefixName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrefixName;
    /**
     * The ProfileGroupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProfileGroupId;
    /**
     * The SalesChannelId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SalesChannelId;
    /**
     * The SuffixName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SuffixName;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The ViewReservations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ViewReservations;
    /**
     * Constructor method for ProfilePersonDefinition
     * @uses ProfilePersonDefinition::setActionTypeImage()
     * @uses ProfilePersonDefinition::setAuthorizationRequired()
     * @uses ProfilePersonDefinition::setBirthday()
     * @uses ProfilePersonDefinition::setBusinessUnitId()
     * @uses ProfilePersonDefinition::setCompany()
     * @uses ProfilePersonDefinition::setCompanyJob()
     * @uses ProfilePersonDefinition::setCompanySector()
     * @uses ProfilePersonDefinition::setDKNumber()
     * @uses ProfilePersonDefinition::setFirstName()
     * @uses ProfilePersonDefinition::setGenderId()
     * @uses ProfilePersonDefinition::setHideCosts()
     * @uses ProfilePersonDefinition::setImage()
     * @uses ProfilePersonDefinition::setIsAdmin()
     * @uses ProfilePersonDefinition::setIsAgent()
     * @uses ProfilePersonDefinition::setIsAuthorizer()
     * @uses ProfilePersonDefinition::setIsPassenger()
     * @uses ProfilePersonDefinition::setJobTitle()
     * @uses ProfilePersonDefinition::setLanguageId()
     * @uses ProfilePersonDefinition::setLastName()
     * @uses ProfilePersonDefinition::setMaritalStatus()
     * @uses ProfilePersonDefinition::setNationality()
     * @uses ProfilePersonDefinition::setPrefixName()
     * @uses ProfilePersonDefinition::setProfileGroupId()
     * @uses ProfilePersonDefinition::setSalesChannelId()
     * @uses ProfilePersonDefinition::setSuffixName()
     * @uses ProfilePersonDefinition::setUserName()
     * @uses ProfilePersonDefinition::setViewReservations()
     * @param string $actionTypeImage
     * @param bool $authorizationRequired
     * @param string $birthday
     * @param int $businessUnitId
     * @param string $company
     * @param string $companyJob
     * @param string $companySector
     * @param string $dKNumber
     * @param string $firstName
     * @param int $genderId
     * @param bool $hideCosts
     * @param \StructType\ProfileImageDefinition $image
     * @param bool $isAdmin
     * @param bool $isAgent
     * @param bool $isAuthorizer
     * @param bool $isPassenger
     * @param string $jobTitle
     * @param string $languageId
     * @param string $lastName
     * @param int $maritalStatus
     * @param string $nationality
     * @param string $prefixName
     * @param int $profileGroupId
     * @param int $salesChannelId
     * @param string $suffixName
     * @param string $userName
     * @param bool $viewReservations
     */
    public function __construct($actionTypeImage = null, $authorizationRequired = null, $birthday = null, $businessUnitId = null, $company = null, $companyJob = null, $companySector = null, $dKNumber = null, $firstName = null, $genderId = null, $hideCosts = null, \StructType\ProfileImageDefinition $image = null, $isAdmin = null, $isAgent = null, $isAuthorizer = null, $isPassenger = null, $jobTitle = null, $languageId = null, $lastName = null, $maritalStatus = null, $nationality = null, $prefixName = null, $profileGroupId = null, $salesChannelId = null, $suffixName = null, $userName = null, $viewReservations = null)
    {
        $this
            ->setActionTypeImage($actionTypeImage)
            ->setAuthorizationRequired($authorizationRequired)
            ->setBirthday($birthday)
            ->setBusinessUnitId($businessUnitId)
            ->setCompany($company)
            ->setCompanyJob($companyJob)
            ->setCompanySector($companySector)
            ->setDKNumber($dKNumber)
            ->setFirstName($firstName)
            ->setGenderId($genderId)
            ->setHideCosts($hideCosts)
            ->setImage($image)
            ->setIsAdmin($isAdmin)
            ->setIsAgent($isAgent)
            ->setIsAuthorizer($isAuthorizer)
            ->setIsPassenger($isPassenger)
            ->setJobTitle($jobTitle)
            ->setLanguageId($languageId)
            ->setLastName($lastName)
            ->setMaritalStatus($maritalStatus)
            ->setNationality($nationality)
            ->setPrefixName($prefixName)
            ->setProfileGroupId($profileGroupId)
            ->setSalesChannelId($salesChannelId)
            ->setSuffixName($suffixName)
            ->setUserName($userName)
            ->setViewReservations($viewReservations);
    }
    /**
     * Get ActionTypeImage value
     * @return string|null
     */
    public function getActionTypeImage()
    {
        return $this->ActionTypeImage;
    }
    /**
     * Set ActionTypeImage value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionTypeImage
     * @return \StructType\ProfilePersonDefinition
     */
    public function setActionTypeImage($actionTypeImage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionTypeImage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionTypeImage, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionTypeImage = $actionTypeImage;
        return $this;
    }
    /**
     * Get AuthorizationRequired value
     * @return bool|null
     */
    public function getAuthorizationRequired()
    {
        return $this->AuthorizationRequired;
    }
    /**
     * Set AuthorizationRequired value
     * @param bool $authorizationRequired
     * @return \StructType\ProfilePersonDefinition
     */
    public function setAuthorizationRequired($authorizationRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($authorizationRequired) && !is_bool($authorizationRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($authorizationRequired)), __LINE__);
        }
        $this->AuthorizationRequired = $authorizationRequired;
        return $this;
    }
    /**
     * Get Birthday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthday()
    {
        return isset($this->Birthday) ? $this->Birthday : null;
    }
    /**
     * Set Birthday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthday
     * @return \StructType\ProfilePersonDefinition
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthday)), __LINE__);
        }
        if (is_null($birthday) || (is_array($birthday) && empty($birthday))) {
            unset($this->Birthday);
        } else {
            $this->Birthday = $birthday;
        }
        return $this;
    }
    /**
     * Get BusinessUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBusinessUnitId()
    {
        return isset($this->BusinessUnitId) ? $this->BusinessUnitId : null;
    }
    /**
     * Set BusinessUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $businessUnitId
     * @return \StructType\ProfilePersonDefinition
     */
    public function setBusinessUnitId($businessUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($businessUnitId) && !is_numeric($businessUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($businessUnitId)), __LINE__);
        }
        if (is_null($businessUnitId) || (is_array($businessUnitId) && empty($businessUnitId))) {
            unset($this->BusinessUnitId);
        } else {
            $this->BusinessUnitId = $businessUnitId;
        }
        return $this;
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $company
     * @return \StructType\ProfilePersonDefinition
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get CompanyJob value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyJob()
    {
        return isset($this->CompanyJob) ? $this->CompanyJob : null;
    }
    /**
     * Set CompanyJob value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyJob
     * @return \StructType\ProfilePersonDefinition
     */
    public function setCompanyJob($companyJob = null)
    {
        // validation for constraint: string
        if (!is_null($companyJob) && !is_string($companyJob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyJob)), __LINE__);
        }
        if (is_null($companyJob) || (is_array($companyJob) && empty($companyJob))) {
            unset($this->CompanyJob);
        } else {
            $this->CompanyJob = $companyJob;
        }
        return $this;
    }
    /**
     * Get CompanySector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanySector()
    {
        return isset($this->CompanySector) ? $this->CompanySector : null;
    }
    /**
     * Set CompanySector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companySector
     * @return \StructType\ProfilePersonDefinition
     */
    public function setCompanySector($companySector = null)
    {
        // validation for constraint: string
        if (!is_null($companySector) && !is_string($companySector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companySector)), __LINE__);
        }
        if (is_null($companySector) || (is_array($companySector) && empty($companySector))) {
            unset($this->CompanySector);
        } else {
            $this->CompanySector = $companySector;
        }
        return $this;
    }
    /**
     * Get DKNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDKNumber()
    {
        return isset($this->DKNumber) ? $this->DKNumber : null;
    }
    /**
     * Set DKNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dKNumber
     * @return \StructType\ProfilePersonDefinition
     */
    public function setDKNumber($dKNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dKNumber) && !is_string($dKNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dKNumber)), __LINE__);
        }
        if (is_null($dKNumber) || (is_array($dKNumber) && empty($dKNumber))) {
            unset($this->DKNumber);
        } else {
            $this->DKNumber = $dKNumber;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\ProfilePersonDefinition
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get GenderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGenderId()
    {
        return isset($this->GenderId) ? $this->GenderId : null;
    }
    /**
     * Set GenderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $genderId
     * @return \StructType\ProfilePersonDefinition
     */
    public function setGenderId($genderId = null)
    {
        // validation for constraint: int
        if (!is_null($genderId) && !is_numeric($genderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($genderId)), __LINE__);
        }
        if (is_null($genderId) || (is_array($genderId) && empty($genderId))) {
            unset($this->GenderId);
        } else {
            $this->GenderId = $genderId;
        }
        return $this;
    }
    /**
     * Get HideCosts value
     * @return bool|null
     */
    public function getHideCosts()
    {
        return $this->HideCosts;
    }
    /**
     * Set HideCosts value
     * @param bool $hideCosts
     * @return \StructType\ProfilePersonDefinition
     */
    public function setHideCosts($hideCosts = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideCosts) && !is_bool($hideCosts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hideCosts)), __LINE__);
        }
        $this->HideCosts = $hideCosts;
        return $this;
    }
    /**
     * Get Image value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProfileImageDefinition|null
     */
    public function getImage()
    {
        return isset($this->Image) ? $this->Image : null;
    }
    /**
     * Set Image value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProfileImageDefinition $image
     * @return \StructType\ProfilePersonDefinition
     */
    public function setImage(\StructType\ProfileImageDefinition $image = null)
    {
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->Image);
        } else {
            $this->Image = $image;
        }
        return $this;
    }
    /**
     * Get IsAdmin value
     * @return bool|null
     */
    public function getIsAdmin()
    {
        return $this->IsAdmin;
    }
    /**
     * Set IsAdmin value
     * @param bool $isAdmin
     * @return \StructType\ProfilePersonDefinition
     */
    public function setIsAdmin($isAdmin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAdmin) && !is_bool($isAdmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAdmin)), __LINE__);
        }
        $this->IsAdmin = $isAdmin;
        return $this;
    }
    /**
     * Get IsAgent value
     * @return bool|null
     */
    public function getIsAgent()
    {
        return $this->IsAgent;
    }
    /**
     * Set IsAgent value
     * @param bool $isAgent
     * @return \StructType\ProfilePersonDefinition
     */
    public function setIsAgent($isAgent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAgent) && !is_bool($isAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAgent)), __LINE__);
        }
        $this->IsAgent = $isAgent;
        return $this;
    }
    /**
     * Get IsAuthorizer value
     * @return bool|null
     */
    public function getIsAuthorizer()
    {
        return $this->IsAuthorizer;
    }
    /**
     * Set IsAuthorizer value
     * @param bool $isAuthorizer
     * @return \StructType\ProfilePersonDefinition
     */
    public function setIsAuthorizer($isAuthorizer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAuthorizer) && !is_bool($isAuthorizer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAuthorizer)), __LINE__);
        }
        $this->IsAuthorizer = $isAuthorizer;
        return $this;
    }
    /**
     * Get IsPassenger value
     * @return bool|null
     */
    public function getIsPassenger()
    {
        return $this->IsPassenger;
    }
    /**
     * Set IsPassenger value
     * @param bool $isPassenger
     * @return \StructType\ProfilePersonDefinition
     */
    public function setIsPassenger($isPassenger = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPassenger) && !is_bool($isPassenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPassenger)), __LINE__);
        }
        $this->IsPassenger = $isPassenger;
        return $this;
    }
    /**
     * Get JobTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobTitle()
    {
        return isset($this->JobTitle) ? $this->JobTitle : null;
    }
    /**
     * Set JobTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jobTitle
     * @return \StructType\ProfilePersonDefinition
     */
    public function setJobTitle($jobTitle = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitle) && !is_string($jobTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jobTitle)), __LINE__);
        }
        if (is_null($jobTitle) || (is_array($jobTitle) && empty($jobTitle))) {
            unset($this->JobTitle);
        } else {
            $this->JobTitle = $jobTitle;
        }
        return $this;
    }
    /**
     * Get LanguageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguageId()
    {
        return isset($this->LanguageId) ? $this->LanguageId : null;
    }
    /**
     * Set LanguageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $languageId
     * @return \StructType\ProfilePersonDefinition
     */
    public function setLanguageId($languageId = null)
    {
        // validation for constraint: string
        if (!is_null($languageId) && !is_string($languageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageId)), __LINE__);
        }
        if (is_null($languageId) || (is_array($languageId) && empty($languageId))) {
            unset($this->LanguageId);
        } else {
            $this->LanguageId = $languageId;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\ProfilePersonDefinition
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get MaritalStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaritalStatus()
    {
        return isset($this->MaritalStatus) ? $this->MaritalStatus : null;
    }
    /**
     * Set MaritalStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maritalStatus
     * @return \StructType\ProfilePersonDefinition
     */
    public function setMaritalStatus($maritalStatus = null)
    {
        // validation for constraint: int
        if (!is_null($maritalStatus) && !is_numeric($maritalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maritalStatus)), __LINE__);
        }
        if (is_null($maritalStatus) || (is_array($maritalStatus) && empty($maritalStatus))) {
            unset($this->MaritalStatus);
        } else {
            $this->MaritalStatus = $maritalStatus;
        }
        return $this;
    }
    /**
     * Get Nationality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationality()
    {
        return isset($this->Nationality) ? $this->Nationality : null;
    }
    /**
     * Set Nationality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nationality
     * @return \StructType\ProfilePersonDefinition
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationality)), __LINE__);
        }
        if (is_null($nationality) || (is_array($nationality) && empty($nationality))) {
            unset($this->Nationality);
        } else {
            $this->Nationality = $nationality;
        }
        return $this;
    }
    /**
     * Get PrefixName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefixName()
    {
        return isset($this->PrefixName) ? $this->PrefixName : null;
    }
    /**
     * Set PrefixName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefixName
     * @return \StructType\ProfilePersonDefinition
     */
    public function setPrefixName($prefixName = null)
    {
        // validation for constraint: string
        if (!is_null($prefixName) && !is_string($prefixName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixName)), __LINE__);
        }
        if (is_null($prefixName) || (is_array($prefixName) && empty($prefixName))) {
            unset($this->PrefixName);
        } else {
            $this->PrefixName = $prefixName;
        }
        return $this;
    }
    /**
     * Get ProfileGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProfileGroupId()
    {
        return isset($this->ProfileGroupId) ? $this->ProfileGroupId : null;
    }
    /**
     * Set ProfileGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $profileGroupId
     * @return \StructType\ProfilePersonDefinition
     */
    public function setProfileGroupId($profileGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($profileGroupId) && !is_numeric($profileGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileGroupId)), __LINE__);
        }
        if (is_null($profileGroupId) || (is_array($profileGroupId) && empty($profileGroupId))) {
            unset($this->ProfileGroupId);
        } else {
            $this->ProfileGroupId = $profileGroupId;
        }
        return $this;
    }
    /**
     * Get SalesChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSalesChannelId()
    {
        return isset($this->SalesChannelId) ? $this->SalesChannelId : null;
    }
    /**
     * Set SalesChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $salesChannelId
     * @return \StructType\ProfilePersonDefinition
     */
    public function setSalesChannelId($salesChannelId = null)
    {
        // validation for constraint: int
        if (!is_null($salesChannelId) && !is_numeric($salesChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesChannelId)), __LINE__);
        }
        if (is_null($salesChannelId) || (is_array($salesChannelId) && empty($salesChannelId))) {
            unset($this->SalesChannelId);
        } else {
            $this->SalesChannelId = $salesChannelId;
        }
        return $this;
    }
    /**
     * Get SuffixName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffixName()
    {
        return isset($this->SuffixName) ? $this->SuffixName : null;
    }
    /**
     * Set SuffixName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffixName
     * @return \StructType\ProfilePersonDefinition
     */
    public function setSuffixName($suffixName = null)
    {
        // validation for constraint: string
        if (!is_null($suffixName) && !is_string($suffixName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suffixName)), __LINE__);
        }
        if (is_null($suffixName) || (is_array($suffixName) && empty($suffixName))) {
            unset($this->SuffixName);
        } else {
            $this->SuffixName = $suffixName;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \StructType\ProfilePersonDefinition
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get ViewReservations value
     * @return bool|null
     */
    public function getViewReservations()
    {
        return $this->ViewReservations;
    }
    /**
     * Set ViewReservations value
     * @param bool $viewReservations
     * @return \StructType\ProfilePersonDefinition
     */
    public function setViewReservations($viewReservations = null)
    {
        // validation for constraint: boolean
        if (!is_null($viewReservations) && !is_bool($viewReservations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($viewReservations)), __LINE__);
        }
        $this->ViewReservations = $viewReservations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfilePersonDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
