<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileIpAddressDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileIpAddressDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfileIpAddressDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The IpAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IpAddress;
    /**
     * The IpAddressId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IpAddressId;
    /**
     * The ProfileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileId;
    /**
     * Constructor method for ProfileIpAddressDefinition
     * @uses ProfileIpAddressDefinition::setActionType()
     * @uses ProfileIpAddressDefinition::setIpAddress()
     * @uses ProfileIpAddressDefinition::setIpAddressId()
     * @uses ProfileIpAddressDefinition::setProfileId()
     * @param string $actionType
     * @param string $ipAddress
     * @param int $ipAddressId
     * @param int $profileId
     */
    public function __construct($actionType = null, $ipAddress = null, $ipAddressId = null, $profileId = null)
    {
        $this
            ->setActionType($actionType)
            ->setIpAddress($ipAddress)
            ->setIpAddressId($ipAddressId)
            ->setProfileId($profileId);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ProfileIpAddressDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get IpAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIpAddress()
    {
        return isset($this->IpAddress) ? $this->IpAddress : null;
    }
    /**
     * Set IpAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ipAddress
     * @return \StructType\ProfileIpAddressDefinition
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        if (is_null($ipAddress) || (is_array($ipAddress) && empty($ipAddress))) {
            unset($this->IpAddress);
        } else {
            $this->IpAddress = $ipAddress;
        }
        return $this;
    }
    /**
     * Get IpAddressId value
     * @return int|null
     */
    public function getIpAddressId()
    {
        return $this->IpAddressId;
    }
    /**
     * Set IpAddressId value
     * @param int $ipAddressId
     * @return \StructType\ProfileIpAddressDefinition
     */
    public function setIpAddressId($ipAddressId = null)
    {
        // validation for constraint: int
        if (!is_null($ipAddressId) && !is_numeric($ipAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ipAddressId)), __LINE__);
        }
        $this->IpAddressId = $ipAddressId;
        return $this;
    }
    /**
     * Get ProfileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\ProfileIpAddressDefinition
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileIpAddressDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
