<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileBaseDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileBaseDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfileBaseDefinition extends AbstractStructBase
{
    /**
     * The AddressList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProfileAddressDefinition
     */
    public $AddressList;
    /**
     * The CardList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProfileCardDefinition
     */
    public $CardList;
    /**
     * The ClientHistories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfClientHistoryDefinition
     */
    public $ClientHistories;
    /**
     * The DocumentList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProfileDocumentDefinition
     */
    public $DocumentList;
    /**
     * The EmailList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProfileEmailDefinition
     */
    public $EmailList;
    /**
     * The HierarchiesList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProfileHierarchyDefinition
     */
    public $HierarchiesList;
    /**
     * The HierarchyType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HierarchyType;
    /**
     * The IpAddressList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProfileIpAddressDefinition
     */
    public $IpAddressList;
    /**
     * The IsInBlackList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsInBlackList;
    /**
     * The LastModification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastModification;
    /**
     * The MarketSegmentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MarketSegmentId;
    /**
     * The OtherBranchesAllow
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OtherBranchesAllow;
    /**
     * The ParentProfileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParentProfileId;
    /**
     * The PhoneList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProfilePhoneDefinition
     */
    public $PhoneList;
    /**
     * The PreferedBranch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProfileCompanyDefinition
     */
    public $PreferedBranch;
    /**
     * The ProfileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileId;
    /**
     * Constructor method for ProfileBaseDefinition
     * @uses ProfileBaseDefinition::setAddressList()
     * @uses ProfileBaseDefinition::setCardList()
     * @uses ProfileBaseDefinition::setClientHistories()
     * @uses ProfileBaseDefinition::setDocumentList()
     * @uses ProfileBaseDefinition::setEmailList()
     * @uses ProfileBaseDefinition::setHierarchiesList()
     * @uses ProfileBaseDefinition::setHierarchyType()
     * @uses ProfileBaseDefinition::setIpAddressList()
     * @uses ProfileBaseDefinition::setIsInBlackList()
     * @uses ProfileBaseDefinition::setLastModification()
     * @uses ProfileBaseDefinition::setMarketSegmentId()
     * @uses ProfileBaseDefinition::setOtherBranchesAllow()
     * @uses ProfileBaseDefinition::setParentProfileId()
     * @uses ProfileBaseDefinition::setPhoneList()
     * @uses ProfileBaseDefinition::setPreferedBranch()
     * @uses ProfileBaseDefinition::setProfileId()
     * @param \ArrayType\ArrayOfProfileAddressDefinition $addressList
     * @param \ArrayType\ArrayOfProfileCardDefinition $cardList
     * @param \ArrayType\ArrayOfClientHistoryDefinition $clientHistories
     * @param \ArrayType\ArrayOfProfileDocumentDefinition $documentList
     * @param \ArrayType\ArrayOfProfileEmailDefinition $emailList
     * @param \ArrayType\ArrayOfProfileHierarchyDefinition $hierarchiesList
     * @param string $hierarchyType
     * @param \ArrayType\ArrayOfProfileIpAddressDefinition $ipAddressList
     * @param bool $isInBlackList
     * @param string $lastModification
     * @param int $marketSegmentId
     * @param bool $otherBranchesAllow
     * @param int $parentProfileId
     * @param \ArrayType\ArrayOfProfilePhoneDefinition $phoneList
     * @param \StructType\ProfileCompanyDefinition $preferedBranch
     * @param int $profileId
     */
    public function __construct(\ArrayType\ArrayOfProfileAddressDefinition $addressList = null, \ArrayType\ArrayOfProfileCardDefinition $cardList = null, \ArrayType\ArrayOfClientHistoryDefinition $clientHistories = null, \ArrayType\ArrayOfProfileDocumentDefinition $documentList = null, \ArrayType\ArrayOfProfileEmailDefinition $emailList = null, \ArrayType\ArrayOfProfileHierarchyDefinition $hierarchiesList = null, $hierarchyType = null, \ArrayType\ArrayOfProfileIpAddressDefinition $ipAddressList = null, $isInBlackList = null, $lastModification = null, $marketSegmentId = null, $otherBranchesAllow = null, $parentProfileId = null, \ArrayType\ArrayOfProfilePhoneDefinition $phoneList = null, \StructType\ProfileCompanyDefinition $preferedBranch = null, $profileId = null)
    {
        $this
            ->setAddressList($addressList)
            ->setCardList($cardList)
            ->setClientHistories($clientHistories)
            ->setDocumentList($documentList)
            ->setEmailList($emailList)
            ->setHierarchiesList($hierarchiesList)
            ->setHierarchyType($hierarchyType)
            ->setIpAddressList($ipAddressList)
            ->setIsInBlackList($isInBlackList)
            ->setLastModification($lastModification)
            ->setMarketSegmentId($marketSegmentId)
            ->setOtherBranchesAllow($otherBranchesAllow)
            ->setParentProfileId($parentProfileId)
            ->setPhoneList($phoneList)
            ->setPreferedBranch($preferedBranch)
            ->setProfileId($profileId);
    }
    /**
     * Get AddressList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProfileAddressDefinition|null
     */
    public function getAddressList()
    {
        return isset($this->AddressList) ? $this->AddressList : null;
    }
    /**
     * Set AddressList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProfileAddressDefinition $addressList
     * @return \StructType\ProfileBaseDefinition
     */
    public function setAddressList(\ArrayType\ArrayOfProfileAddressDefinition $addressList = null)
    {
        if (is_null($addressList) || (is_array($addressList) && empty($addressList))) {
            unset($this->AddressList);
        } else {
            $this->AddressList = $addressList;
        }
        return $this;
    }
    /**
     * Get CardList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProfileCardDefinition|null
     */
    public function getCardList()
    {
        return isset($this->CardList) ? $this->CardList : null;
    }
    /**
     * Set CardList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProfileCardDefinition $cardList
     * @return \StructType\ProfileBaseDefinition
     */
    public function setCardList(\ArrayType\ArrayOfProfileCardDefinition $cardList = null)
    {
        if (is_null($cardList) || (is_array($cardList) && empty($cardList))) {
            unset($this->CardList);
        } else {
            $this->CardList = $cardList;
        }
        return $this;
    }
    /**
     * Get ClientHistories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfClientHistoryDefinition|null
     */
    public function getClientHistories()
    {
        return isset($this->ClientHistories) ? $this->ClientHistories : null;
    }
    /**
     * Set ClientHistories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfClientHistoryDefinition $clientHistories
     * @return \StructType\ProfileBaseDefinition
     */
    public function setClientHistories(\ArrayType\ArrayOfClientHistoryDefinition $clientHistories = null)
    {
        if (is_null($clientHistories) || (is_array($clientHistories) && empty($clientHistories))) {
            unset($this->ClientHistories);
        } else {
            $this->ClientHistories = $clientHistories;
        }
        return $this;
    }
    /**
     * Get DocumentList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProfileDocumentDefinition|null
     */
    public function getDocumentList()
    {
        return isset($this->DocumentList) ? $this->DocumentList : null;
    }
    /**
     * Set DocumentList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProfileDocumentDefinition $documentList
     * @return \StructType\ProfileBaseDefinition
     */
    public function setDocumentList(\ArrayType\ArrayOfProfileDocumentDefinition $documentList = null)
    {
        if (is_null($documentList) || (is_array($documentList) && empty($documentList))) {
            unset($this->DocumentList);
        } else {
            $this->DocumentList = $documentList;
        }
        return $this;
    }
    /**
     * Get EmailList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProfileEmailDefinition|null
     */
    public function getEmailList()
    {
        return isset($this->EmailList) ? $this->EmailList : null;
    }
    /**
     * Set EmailList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProfileEmailDefinition $emailList
     * @return \StructType\ProfileBaseDefinition
     */
    public function setEmailList(\ArrayType\ArrayOfProfileEmailDefinition $emailList = null)
    {
        if (is_null($emailList) || (is_array($emailList) && empty($emailList))) {
            unset($this->EmailList);
        } else {
            $this->EmailList = $emailList;
        }
        return $this;
    }
    /**
     * Get HierarchiesList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProfileHierarchyDefinition|null
     */
    public function getHierarchiesList()
    {
        return isset($this->HierarchiesList) ? $this->HierarchiesList : null;
    }
    /**
     * Set HierarchiesList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProfileHierarchyDefinition $hierarchiesList
     * @return \StructType\ProfileBaseDefinition
     */
    public function setHierarchiesList(\ArrayType\ArrayOfProfileHierarchyDefinition $hierarchiesList = null)
    {
        if (is_null($hierarchiesList) || (is_array($hierarchiesList) && empty($hierarchiesList))) {
            unset($this->HierarchiesList);
        } else {
            $this->HierarchiesList = $hierarchiesList;
        }
        return $this;
    }
    /**
     * Get HierarchyType value
     * @return string|null
     */
    public function getHierarchyType()
    {
        return $this->HierarchyType;
    }
    /**
     * Set HierarchyType value
     * @uses \EnumType\ProfileHierarchyType::valueIsValid()
     * @uses \EnumType\ProfileHierarchyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hierarchyType
     * @return \StructType\ProfileBaseDefinition
     */
    public function setHierarchyType($hierarchyType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProfileHierarchyType::valueIsValid($hierarchyType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hierarchyType, implode(', ', \EnumType\ProfileHierarchyType::getValidValues())), __LINE__);
        }
        $this->HierarchyType = $hierarchyType;
        return $this;
    }
    /**
     * Get IpAddressList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProfileIpAddressDefinition|null
     */
    public function getIpAddressList()
    {
        return isset($this->IpAddressList) ? $this->IpAddressList : null;
    }
    /**
     * Set IpAddressList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProfileIpAddressDefinition $ipAddressList
     * @return \StructType\ProfileBaseDefinition
     */
    public function setIpAddressList(\ArrayType\ArrayOfProfileIpAddressDefinition $ipAddressList = null)
    {
        if (is_null($ipAddressList) || (is_array($ipAddressList) && empty($ipAddressList))) {
            unset($this->IpAddressList);
        } else {
            $this->IpAddressList = $ipAddressList;
        }
        return $this;
    }
    /**
     * Get IsInBlackList value
     * @return bool|null
     */
    public function getIsInBlackList()
    {
        return $this->IsInBlackList;
    }
    /**
     * Set IsInBlackList value
     * @param bool $isInBlackList
     * @return \StructType\ProfileBaseDefinition
     */
    public function setIsInBlackList($isInBlackList = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInBlackList) && !is_bool($isInBlackList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isInBlackList)), __LINE__);
        }
        $this->IsInBlackList = $isInBlackList;
        return $this;
    }
    /**
     * Get LastModification value
     * @return string|null
     */
    public function getLastModification()
    {
        return $this->LastModification;
    }
    /**
     * Set LastModification value
     * @param string $lastModification
     * @return \StructType\ProfileBaseDefinition
     */
    public function setLastModification($lastModification = null)
    {
        // validation for constraint: string
        if (!is_null($lastModification) && !is_string($lastModification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModification)), __LINE__);
        }
        $this->LastModification = $lastModification;
        return $this;
    }
    /**
     * Get MarketSegmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMarketSegmentId()
    {
        return isset($this->MarketSegmentId) ? $this->MarketSegmentId : null;
    }
    /**
     * Set MarketSegmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $marketSegmentId
     * @return \StructType\ProfileBaseDefinition
     */
    public function setMarketSegmentId($marketSegmentId = null)
    {
        // validation for constraint: int
        if (!is_null($marketSegmentId) && !is_numeric($marketSegmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($marketSegmentId)), __LINE__);
        }
        if (is_null($marketSegmentId) || (is_array($marketSegmentId) && empty($marketSegmentId))) {
            unset($this->MarketSegmentId);
        } else {
            $this->MarketSegmentId = $marketSegmentId;
        }
        return $this;
    }
    /**
     * Get OtherBranchesAllow value
     * @return bool|null
     */
    public function getOtherBranchesAllow()
    {
        return $this->OtherBranchesAllow;
    }
    /**
     * Set OtherBranchesAllow value
     * @param bool $otherBranchesAllow
     * @return \StructType\ProfileBaseDefinition
     */
    public function setOtherBranchesAllow($otherBranchesAllow = null)
    {
        // validation for constraint: boolean
        if (!is_null($otherBranchesAllow) && !is_bool($otherBranchesAllow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($otherBranchesAllow)), __LINE__);
        }
        $this->OtherBranchesAllow = $otherBranchesAllow;
        return $this;
    }
    /**
     * Get ParentProfileId value
     * @return int|null
     */
    public function getParentProfileId()
    {
        return $this->ParentProfileId;
    }
    /**
     * Set ParentProfileId value
     * @param int $parentProfileId
     * @return \StructType\ProfileBaseDefinition
     */
    public function setParentProfileId($parentProfileId = null)
    {
        // validation for constraint: int
        if (!is_null($parentProfileId) && !is_numeric($parentProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parentProfileId)), __LINE__);
        }
        $this->ParentProfileId = $parentProfileId;
        return $this;
    }
    /**
     * Get PhoneList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProfilePhoneDefinition|null
     */
    public function getPhoneList()
    {
        return isset($this->PhoneList) ? $this->PhoneList : null;
    }
    /**
     * Set PhoneList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProfilePhoneDefinition $phoneList
     * @return \StructType\ProfileBaseDefinition
     */
    public function setPhoneList(\ArrayType\ArrayOfProfilePhoneDefinition $phoneList = null)
    {
        if (is_null($phoneList) || (is_array($phoneList) && empty($phoneList))) {
            unset($this->PhoneList);
        } else {
            $this->PhoneList = $phoneList;
        }
        return $this;
    }
    /**
     * Get PreferedBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProfileCompanyDefinition|null
     */
    public function getPreferedBranch()
    {
        return isset($this->PreferedBranch) ? $this->PreferedBranch : null;
    }
    /**
     * Set PreferedBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProfileCompanyDefinition $preferedBranch
     * @return \StructType\ProfileBaseDefinition
     */
    public function setPreferedBranch(\StructType\ProfileCompanyDefinition $preferedBranch = null)
    {
        if (is_null($preferedBranch) || (is_array($preferedBranch) && empty($preferedBranch))) {
            unset($this->PreferedBranch);
        } else {
            $this->PreferedBranch = $preferedBranch;
        }
        return $this;
    }
    /**
     * Get ProfileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\ProfileBaseDefinition
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileBaseDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
