<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PercentageAmountDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PercentageAmountDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class PercentageAmountDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CurrencyAmountDefinition
     */
    public $Amount;
    /**
     * The ApplicationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationType;
    /**
     * The CommissionOverTotalAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CommissionOverTotalAmount;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Percentage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Percentage;
    /**
     * Constructor method for PercentageAmountDefinition
     * @uses PercentageAmountDefinition::setActionType()
     * @uses PercentageAmountDefinition::setAmount()
     * @uses PercentageAmountDefinition::setApplicationType()
     * @uses PercentageAmountDefinition::setCommissionOverTotalAmount()
     * @uses PercentageAmountDefinition::setId()
     * @uses PercentageAmountDefinition::setPercentage()
     * @param string $actionType
     * @param \StructType\CurrencyAmountDefinition $amount
     * @param string $applicationType
     * @param bool $commissionOverTotalAmount
     * @param int $id
     * @param float $percentage
     */
    public function __construct($actionType = null, \StructType\CurrencyAmountDefinition $amount = null, $applicationType = null, $commissionOverTotalAmount = null, $id = null, $percentage = null)
    {
        $this
            ->setActionType($actionType)
            ->setAmount($amount)
            ->setApplicationType($applicationType)
            ->setCommissionOverTotalAmount($commissionOverTotalAmount)
            ->setId($id)
            ->setPercentage($percentage);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\PercentageAmountDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CurrencyAmountDefinition|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CurrencyAmountDefinition $amount
     * @return \StructType\PercentageAmountDefinition
     */
    public function setAmount(\StructType\CurrencyAmountDefinition $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get ApplicationType value
     * @return string|null
     */
    public function getApplicationType()
    {
        return $this->ApplicationType;
    }
    /**
     * Set ApplicationType value
     * @uses \EnumType\AmountType::valueIsValid()
     * @uses \EnumType\AmountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applicationType
     * @return \StructType\PercentageAmountDefinition
     */
    public function setApplicationType($applicationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AmountType::valueIsValid($applicationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $applicationType, implode(', ', \EnumType\AmountType::getValidValues())), __LINE__);
        }
        $this->ApplicationType = $applicationType;
        return $this;
    }
    /**
     * Get CommissionOverTotalAmount value
     * @return bool|null
     */
    public function getCommissionOverTotalAmount()
    {
        return $this->CommissionOverTotalAmount;
    }
    /**
     * Set CommissionOverTotalAmount value
     * @param bool $commissionOverTotalAmount
     * @return \StructType\PercentageAmountDefinition
     */
    public function setCommissionOverTotalAmount($commissionOverTotalAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionOverTotalAmount) && !is_bool($commissionOverTotalAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($commissionOverTotalAmount)), __LINE__);
        }
        $this->CommissionOverTotalAmount = $commissionOverTotalAmount;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\PercentageAmountDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\PercentageAmountDefinition
     */
    public function setPercentage($percentage = null)
    {
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PercentageAmountDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
