<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerCountDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PassengerCountDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class PassengerCountDefinition extends AbstractStructBase
{
    /**
     * The PassengerAge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $PassengerAge;
    /**
     * The PassengerCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PassengerCount;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PassengerType;
    /**
     * Constructor method for PassengerCountDefinition
     * @uses PassengerCountDefinition::setPassengerAge()
     * @uses PassengerCountDefinition::setPassengerCount()
     * @uses PassengerCountDefinition::setPassengerType()
     * @param \ArrayType\ArrayOfint $passengerAge
     * @param int $passengerCount
     * @param string $passengerType
     */
    public function __construct(\ArrayType\ArrayOfint $passengerAge = null, $passengerCount = null, $passengerType = null)
    {
        $this
            ->setPassengerAge($passengerAge)
            ->setPassengerCount($passengerCount)
            ->setPassengerType($passengerType);
    }
    /**
     * Get PassengerAge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getPassengerAge()
    {
        return isset($this->PassengerAge) ? $this->PassengerAge : null;
    }
    /**
     * Set PassengerAge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $passengerAge
     * @return \StructType\PassengerCountDefinition
     */
    public function setPassengerAge(\ArrayType\ArrayOfint $passengerAge = null)
    {
        if (is_null($passengerAge) || (is_array($passengerAge) && empty($passengerAge))) {
            unset($this->PassengerAge);
        } else {
            $this->PassengerAge = $passengerAge;
        }
        return $this;
    }
    /**
     * Get PassengerCount value
     * @return int|null
     */
    public function getPassengerCount()
    {
        return $this->PassengerCount;
    }
    /**
     * Set PassengerCount value
     * @param int $passengerCount
     * @return \StructType\PassengerCountDefinition
     */
    public function setPassengerCount($passengerCount = null)
    {
        // validation for constraint: int
        if (!is_null($passengerCount) && !is_numeric($passengerCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($passengerCount)), __LINE__);
        }
        $this->PassengerCount = $passengerCount;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @uses \EnumType\PassengerType::valueIsValid()
     * @uses \EnumType\PassengerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $passengerType
     * @return \StructType\PassengerCountDefinition
     */
    public function setPassengerType($passengerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PassengerType::valueIsValid($passengerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $passengerType, implode(', ', \EnumType\PassengerType::getValidValues())), __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PassengerCountDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
