<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageItemDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ImageItemDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ImageItemDefinition extends AbstractStructBase
{
    /**
     * The ImageDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageDescription;
    /**
     * The ImageURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageURL;
    /**
     * The IsThumbnail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsThumbnail;
    /**
     * Constructor method for ImageItemDefinition
     * @uses ImageItemDefinition::setImageDescription()
     * @uses ImageItemDefinition::setImageURL()
     * @uses ImageItemDefinition::setIsThumbnail()
     * @param string $imageDescription
     * @param string $imageURL
     * @param bool $isThumbnail
     */
    public function __construct($imageDescription = null, $imageURL = null, $isThumbnail = null)
    {
        $this
            ->setImageDescription($imageDescription)
            ->setImageURL($imageURL)
            ->setIsThumbnail($isThumbnail);
    }
    /**
     * Get ImageDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageDescription()
    {
        return isset($this->ImageDescription) ? $this->ImageDescription : null;
    }
    /**
     * Set ImageDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageDescription
     * @return \StructType\ImageItemDefinition
     */
    public function setImageDescription($imageDescription = null)
    {
        // validation for constraint: string
        if (!is_null($imageDescription) && !is_string($imageDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageDescription)), __LINE__);
        }
        if (is_null($imageDescription) || (is_array($imageDescription) && empty($imageDescription))) {
            unset($this->ImageDescription);
        } else {
            $this->ImageDescription = $imageDescription;
        }
        return $this;
    }
    /**
     * Get ImageURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageURL()
    {
        return isset($this->ImageURL) ? $this->ImageURL : null;
    }
    /**
     * Set ImageURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageURL
     * @return \StructType\ImageItemDefinition
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageURL)), __LINE__);
        }
        if (is_null($imageURL) || (is_array($imageURL) && empty($imageURL))) {
            unset($this->ImageURL);
        } else {
            $this->ImageURL = $imageURL;
        }
        return $this;
    }
    /**
     * Get IsThumbnail value
     * @return bool|null
     */
    public function getIsThumbnail()
    {
        return $this->IsThumbnail;
    }
    /**
     * Set IsThumbnail value
     * @param bool $isThumbnail
     * @return \StructType\ImageItemDefinition
     */
    public function setIsThumbnail($isThumbnail = null)
    {
        // validation for constraint: boolean
        if (!is_null($isThumbnail) && !is_bool($isThumbnail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isThumbnail)), __LINE__);
        }
        $this->IsThumbnail = $isThumbnail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ImageItemDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
