<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservationSearchDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelReservationSearchDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class HotelReservationSearchDefinition extends AbstractStructBase
{
    /**
     * The BookingTimeLimitDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingTimeLimitDate;
    /**
     * The BookingTimeLimitToDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingTimeLimitToDate;
    /**
     * The CheckInDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CheckInDate;
    /**
     * The CheckInToDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CheckInToDate;
    /**
     * The CheckOutDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CheckOutDate;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The CreationToDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationToDate;
    /**
     * The DestinationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationCode;
    /**
     * The FileNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileNumber;
    /**
     * The FirstPassengerEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstPassengerEmail;
    /**
     * The HotelName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelName;
    /**
     * The HotelRoomBookingId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HotelRoomBookingId;
    /**
     * The InventoryBlockCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InventoryBlockCode;
    /**
     * The OwnerProfileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OwnerProfileId;
    /**
     * The PassengerName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassengerName;
    /**
     * The PaymentStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SupplierId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SupplierId;
    /**
     * Constructor method for HotelReservationSearchDefinition
     * @uses HotelReservationSearchDefinition::setBookingTimeLimitDate()
     * @uses HotelReservationSearchDefinition::setBookingTimeLimitToDate()
     * @uses HotelReservationSearchDefinition::setCheckInDate()
     * @uses HotelReservationSearchDefinition::setCheckInToDate()
     * @uses HotelReservationSearchDefinition::setCheckOutDate()
     * @uses HotelReservationSearchDefinition::setCreationDate()
     * @uses HotelReservationSearchDefinition::setCreationToDate()
     * @uses HotelReservationSearchDefinition::setDestinationCode()
     * @uses HotelReservationSearchDefinition::setFileNumber()
     * @uses HotelReservationSearchDefinition::setFirstPassengerEmail()
     * @uses HotelReservationSearchDefinition::setHotelName()
     * @uses HotelReservationSearchDefinition::setHotelRoomBookingId()
     * @uses HotelReservationSearchDefinition::setInventoryBlockCode()
     * @uses HotelReservationSearchDefinition::setOwnerProfileId()
     * @uses HotelReservationSearchDefinition::setPassengerName()
     * @uses HotelReservationSearchDefinition::setPaymentStatus()
     * @uses HotelReservationSearchDefinition::setStatus()
     * @uses HotelReservationSearchDefinition::setSupplierId()
     * @param string $bookingTimeLimitDate
     * @param string $bookingTimeLimitToDate
     * @param string $checkInDate
     * @param string $checkInToDate
     * @param string $checkOutDate
     * @param string $creationDate
     * @param string $creationToDate
     * @param string $destinationCode
     * @param string $fileNumber
     * @param string $firstPassengerEmail
     * @param string $hotelName
     * @param int $hotelRoomBookingId
     * @param string $inventoryBlockCode
     * @param int $ownerProfileId
     * @param string $passengerName
     * @param string $paymentStatus
     * @param string $status
     * @param int $supplierId
     */
    public function __construct($bookingTimeLimitDate = null, $bookingTimeLimitToDate = null, $checkInDate = null, $checkInToDate = null, $checkOutDate = null, $creationDate = null, $creationToDate = null, $destinationCode = null, $fileNumber = null, $firstPassengerEmail = null, $hotelName = null, $hotelRoomBookingId = null, $inventoryBlockCode = null, $ownerProfileId = null, $passengerName = null, $paymentStatus = null, $status = null, $supplierId = null)
    {
        $this
            ->setBookingTimeLimitDate($bookingTimeLimitDate)
            ->setBookingTimeLimitToDate($bookingTimeLimitToDate)
            ->setCheckInDate($checkInDate)
            ->setCheckInToDate($checkInToDate)
            ->setCheckOutDate($checkOutDate)
            ->setCreationDate($creationDate)
            ->setCreationToDate($creationToDate)
            ->setDestinationCode($destinationCode)
            ->setFileNumber($fileNumber)
            ->setFirstPassengerEmail($firstPassengerEmail)
            ->setHotelName($hotelName)
            ->setHotelRoomBookingId($hotelRoomBookingId)
            ->setInventoryBlockCode($inventoryBlockCode)
            ->setOwnerProfileId($ownerProfileId)
            ->setPassengerName($passengerName)
            ->setPaymentStatus($paymentStatus)
            ->setStatus($status)
            ->setSupplierId($supplierId);
    }
    /**
     * Get BookingTimeLimitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingTimeLimitDate()
    {
        return isset($this->BookingTimeLimitDate) ? $this->BookingTimeLimitDate : null;
    }
    /**
     * Set BookingTimeLimitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingTimeLimitDate
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setBookingTimeLimitDate($bookingTimeLimitDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookingTimeLimitDate) && !is_string($bookingTimeLimitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingTimeLimitDate)), __LINE__);
        }
        if (is_null($bookingTimeLimitDate) || (is_array($bookingTimeLimitDate) && empty($bookingTimeLimitDate))) {
            unset($this->BookingTimeLimitDate);
        } else {
            $this->BookingTimeLimitDate = $bookingTimeLimitDate;
        }
        return $this;
    }
    /**
     * Get BookingTimeLimitToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingTimeLimitToDate()
    {
        return isset($this->BookingTimeLimitToDate) ? $this->BookingTimeLimitToDate : null;
    }
    /**
     * Set BookingTimeLimitToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingTimeLimitToDate
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setBookingTimeLimitToDate($bookingTimeLimitToDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookingTimeLimitToDate) && !is_string($bookingTimeLimitToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingTimeLimitToDate)), __LINE__);
        }
        if (is_null($bookingTimeLimitToDate) || (is_array($bookingTimeLimitToDate) && empty($bookingTimeLimitToDate))) {
            unset($this->BookingTimeLimitToDate);
        } else {
            $this->BookingTimeLimitToDate = $bookingTimeLimitToDate;
        }
        return $this;
    }
    /**
     * Get CheckInDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckInDate()
    {
        return isset($this->CheckInDate) ? $this->CheckInDate : null;
    }
    /**
     * Set CheckInDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkInDate
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setCheckInDate($checkInDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDate) && !is_string($checkInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkInDate)), __LINE__);
        }
        if (is_null($checkInDate) || (is_array($checkInDate) && empty($checkInDate))) {
            unset($this->CheckInDate);
        } else {
            $this->CheckInDate = $checkInDate;
        }
        return $this;
    }
    /**
     * Get CheckInToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckInToDate()
    {
        return isset($this->CheckInToDate) ? $this->CheckInToDate : null;
    }
    /**
     * Set CheckInToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkInToDate
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setCheckInToDate($checkInToDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInToDate) && !is_string($checkInToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkInToDate)), __LINE__);
        }
        if (is_null($checkInToDate) || (is_array($checkInToDate) && empty($checkInToDate))) {
            unset($this->CheckInToDate);
        } else {
            $this->CheckInToDate = $checkInToDate;
        }
        return $this;
    }
    /**
     * Get CheckOutDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckOutDate()
    {
        return isset($this->CheckOutDate) ? $this->CheckOutDate : null;
    }
    /**
     * Set CheckOutDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkOutDate
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setCheckOutDate($checkOutDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkOutDate) && !is_string($checkOutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkOutDate)), __LINE__);
        }
        if (is_null($checkOutDate) || (is_array($checkOutDate) && empty($checkOutDate))) {
            unset($this->CheckOutDate);
        } else {
            $this->CheckOutDate = $checkOutDate;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get CreationToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationToDate()
    {
        return isset($this->CreationToDate) ? $this->CreationToDate : null;
    }
    /**
     * Set CreationToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationToDate
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setCreationToDate($creationToDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationToDate) && !is_string($creationToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationToDate)), __LINE__);
        }
        if (is_null($creationToDate) || (is_array($creationToDate) && empty($creationToDate))) {
            unset($this->CreationToDate);
        } else {
            $this->CreationToDate = $creationToDate;
        }
        return $this;
    }
    /**
     * Get DestinationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationCode()
    {
        return isset($this->DestinationCode) ? $this->DestinationCode : null;
    }
    /**
     * Set DestinationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationCode
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setDestinationCode($destinationCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCode) && !is_string($destinationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationCode)), __LINE__);
        }
        if (is_null($destinationCode) || (is_array($destinationCode) && empty($destinationCode))) {
            unset($this->DestinationCode);
        } else {
            $this->DestinationCode = $destinationCode;
        }
        return $this;
    }
    /**
     * Get FileNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileNumber()
    {
        return isset($this->FileNumber) ? $this->FileNumber : null;
    }
    /**
     * Set FileNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileNumber
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setFileNumber($fileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fileNumber) && !is_string($fileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileNumber)), __LINE__);
        }
        if (is_null($fileNumber) || (is_array($fileNumber) && empty($fileNumber))) {
            unset($this->FileNumber);
        } else {
            $this->FileNumber = $fileNumber;
        }
        return $this;
    }
    /**
     * Get FirstPassengerEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstPassengerEmail()
    {
        return isset($this->FirstPassengerEmail) ? $this->FirstPassengerEmail : null;
    }
    /**
     * Set FirstPassengerEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstPassengerEmail
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setFirstPassengerEmail($firstPassengerEmail = null)
    {
        // validation for constraint: string
        if (!is_null($firstPassengerEmail) && !is_string($firstPassengerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstPassengerEmail)), __LINE__);
        }
        if (is_null($firstPassengerEmail) || (is_array($firstPassengerEmail) && empty($firstPassengerEmail))) {
            unset($this->FirstPassengerEmail);
        } else {
            $this->FirstPassengerEmail = $firstPassengerEmail;
        }
        return $this;
    }
    /**
     * Get HotelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelName()
    {
        return isset($this->HotelName) ? $this->HotelName : null;
    }
    /**
     * Set HotelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelName
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelName)), __LINE__);
        }
        if (is_null($hotelName) || (is_array($hotelName) && empty($hotelName))) {
            unset($this->HotelName);
        } else {
            $this->HotelName = $hotelName;
        }
        return $this;
    }
    /**
     * Get HotelRoomBookingId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHotelRoomBookingId()
    {
        return isset($this->HotelRoomBookingId) ? $this->HotelRoomBookingId : null;
    }
    /**
     * Set HotelRoomBookingId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hotelRoomBookingId
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setHotelRoomBookingId($hotelRoomBookingId = null)
    {
        // validation for constraint: int
        if (!is_null($hotelRoomBookingId) && !is_numeric($hotelRoomBookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hotelRoomBookingId)), __LINE__);
        }
        if (is_null($hotelRoomBookingId) || (is_array($hotelRoomBookingId) && empty($hotelRoomBookingId))) {
            unset($this->HotelRoomBookingId);
        } else {
            $this->HotelRoomBookingId = $hotelRoomBookingId;
        }
        return $this;
    }
    /**
     * Get InventoryBlockCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryBlockCode()
    {
        return isset($this->InventoryBlockCode) ? $this->InventoryBlockCode : null;
    }
    /**
     * Set InventoryBlockCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryBlockCode
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setInventoryBlockCode($inventoryBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryBlockCode) && !is_string($inventoryBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inventoryBlockCode)), __LINE__);
        }
        if (is_null($inventoryBlockCode) || (is_array($inventoryBlockCode) && empty($inventoryBlockCode))) {
            unset($this->InventoryBlockCode);
        } else {
            $this->InventoryBlockCode = $inventoryBlockCode;
        }
        return $this;
    }
    /**
     * Get OwnerProfileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOwnerProfileId()
    {
        return isset($this->OwnerProfileId) ? $this->OwnerProfileId : null;
    }
    /**
     * Set OwnerProfileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ownerProfileId
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setOwnerProfileId($ownerProfileId = null)
    {
        // validation for constraint: int
        if (!is_null($ownerProfileId) && !is_numeric($ownerProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ownerProfileId)), __LINE__);
        }
        if (is_null($ownerProfileId) || (is_array($ownerProfileId) && empty($ownerProfileId))) {
            unset($this->OwnerProfileId);
        } else {
            $this->OwnerProfileId = $ownerProfileId;
        }
        return $this;
    }
    /**
     * Get PassengerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassengerName()
    {
        return isset($this->PassengerName) ? $this->PassengerName : null;
    }
    /**
     * Set PassengerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passengerName
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setPassengerName($passengerName = null)
    {
        // validation for constraint: string
        if (!is_null($passengerName) && !is_string($passengerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerName)), __LINE__);
        }
        if (is_null($passengerName) || (is_array($passengerName) && empty($passengerName))) {
            unset($this->PassengerName);
        } else {
            $this->PassengerName = $passengerName;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ResevationPaymentStatusType::valueIsValid()
     * @uses \EnumType\ResevationPaymentStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResevationPaymentStatusType::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentStatus, implode(', ', \EnumType\ResevationPaymentStatusType::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\HotelReservationStatusType::valueIsValid()
     * @uses \EnumType\HotelReservationStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelReservationStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\HotelReservationStatusType::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SupplierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSupplierId()
    {
        return isset($this->SupplierId) ? $this->SupplierId : null;
    }
    /**
     * Set SupplierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $supplierId
     * @return \StructType\HotelReservationSearchDefinition
     */
    public function setSupplierId($supplierId = null)
    {
        // validation for constraint: int
        if (!is_null($supplierId) && !is_numeric($supplierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($supplierId)), __LINE__);
        }
        if (is_null($supplierId) || (is_array($supplierId) && empty($supplierId))) {
            unset($this->SupplierId);
        } else {
            $this->SupplierId = $supplierId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelReservationSearchDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
