<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelInfoRoomTypeDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelInfoRoomTypeDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class HotelInfoRoomTypeDefinition extends AbstractStructBase
{
    /**
     * The Amenities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Amenities;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The HotelInfoId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelInfoId;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Images;
    /**
     * The RoomCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoomCode;
    /**
     * Constructor method for HotelInfoRoomTypeDefinition
     * @uses HotelInfoRoomTypeDefinition::setAmenities()
     * @uses HotelInfoRoomTypeDefinition::setDescription()
     * @uses HotelInfoRoomTypeDefinition::setHotelInfoId()
     * @uses HotelInfoRoomTypeDefinition::setId()
     * @uses HotelInfoRoomTypeDefinition::setImages()
     * @uses HotelInfoRoomTypeDefinition::setRoomCode()
     * @param \ArrayType\ArrayOfstring $amenities
     * @param string $description
     * @param int $hotelInfoId
     * @param int $id
     * @param \ArrayType\ArrayOfstring $images
     * @param string $roomCode
     */
    public function __construct(\ArrayType\ArrayOfstring $amenities = null, $description = null, $hotelInfoId = null, $id = null, \ArrayType\ArrayOfstring $images = null, $roomCode = null)
    {
        $this
            ->setAmenities($amenities)
            ->setDescription($description)
            ->setHotelInfoId($hotelInfoId)
            ->setId($id)
            ->setImages($images)
            ->setRoomCode($roomCode);
    }
    /**
     * Get Amenities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getAmenities()
    {
        return isset($this->Amenities) ? $this->Amenities : null;
    }
    /**
     * Set Amenities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $amenities
     * @return \StructType\HotelInfoRoomTypeDefinition
     */
    public function setAmenities(\ArrayType\ArrayOfstring $amenities = null)
    {
        if (is_null($amenities) || (is_array($amenities) && empty($amenities))) {
            unset($this->Amenities);
        } else {
            $this->Amenities = $amenities;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\HotelInfoRoomTypeDefinition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get HotelInfoId value
     * @return int|null
     */
    public function getHotelInfoId()
    {
        return $this->HotelInfoId;
    }
    /**
     * Set HotelInfoId value
     * @param int $hotelInfoId
     * @return \StructType\HotelInfoRoomTypeDefinition
     */
    public function setHotelInfoId($hotelInfoId = null)
    {
        // validation for constraint: int
        if (!is_null($hotelInfoId) && !is_numeric($hotelInfoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hotelInfoId)), __LINE__);
        }
        $this->HotelInfoId = $hotelInfoId;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\HotelInfoRoomTypeDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Images value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getImages()
    {
        return isset($this->Images) ? $this->Images : null;
    }
    /**
     * Set Images value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $images
     * @return \StructType\HotelInfoRoomTypeDefinition
     */
    public function setImages(\ArrayType\ArrayOfstring $images = null)
    {
        if (is_null($images) || (is_array($images) && empty($images))) {
            unset($this->Images);
        } else {
            $this->Images = $images;
        }
        return $this;
    }
    /**
     * Get RoomCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomCode()
    {
        return isset($this->RoomCode) ? $this->RoomCode : null;
    }
    /**
     * Set RoomCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomCode
     * @return \StructType\HotelInfoRoomTypeDefinition
     */
    public function setRoomCode($roomCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomCode) && !is_string($roomCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomCode)), __LINE__);
        }
        if (is_null($roomCode) || (is_array($roomCode) && empty($roomCode))) {
            unset($this->RoomCode);
        } else {
            $this->RoomCode = $roomCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelInfoRoomTypeDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
