<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DiscountDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class DiscountDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PercentageAmountDefinition
     */
    public $Amount;
    /**
     * The DiscountCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DiscountCode;
    /**
     * The DiscountType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DiscountType;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IncludingTaxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludingTaxes;
    /**
     * Constructor method for DiscountDefinition
     * @uses DiscountDefinition::setActionType()
     * @uses DiscountDefinition::setAmount()
     * @uses DiscountDefinition::setDiscountCode()
     * @uses DiscountDefinition::setDiscountType()
     * @uses DiscountDefinition::setId()
     * @uses DiscountDefinition::setIncludingTaxes()
     * @param string $actionType
     * @param \StructType\PercentageAmountDefinition $amount
     * @param string $discountCode
     * @param string $discountType
     * @param int $id
     * @param bool $includingTaxes
     */
    public function __construct($actionType = null, \StructType\PercentageAmountDefinition $amount = null, $discountCode = null, $discountType = null, $id = null, $includingTaxes = null)
    {
        $this
            ->setActionType($actionType)
            ->setAmount($amount)
            ->setDiscountCode($discountCode)
            ->setDiscountType($discountType)
            ->setId($id)
            ->setIncludingTaxes($includingTaxes);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\DiscountDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PercentageAmountDefinition|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PercentageAmountDefinition $amount
     * @return \StructType\DiscountDefinition
     */
    public function setAmount(\StructType\PercentageAmountDefinition $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get DiscountCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiscountCode()
    {
        return isset($this->DiscountCode) ? $this->DiscountCode : null;
    }
    /**
     * Set DiscountCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $discountCode
     * @return \StructType\DiscountDefinition
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountCode)), __LINE__);
        }
        if (is_null($discountCode) || (is_array($discountCode) && empty($discountCode))) {
            unset($this->DiscountCode);
        } else {
            $this->DiscountCode = $discountCode;
        }
        return $this;
    }
    /**
     * Get DiscountType value
     * @return string|null
     */
    public function getDiscountType()
    {
        return $this->DiscountType;
    }
    /**
     * Set DiscountType value
     * @uses \EnumType\DiscountType::valueIsValid()
     * @uses \EnumType\DiscountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $discountType
     * @return \StructType\DiscountDefinition
     */
    public function setDiscountType($discountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DiscountType::valueIsValid($discountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $discountType, implode(', ', \EnumType\DiscountType::getValidValues())), __LINE__);
        }
        $this->DiscountType = $discountType;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DiscountDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IncludingTaxes value
     * @return bool|null
     */
    public function getIncludingTaxes()
    {
        return $this->IncludingTaxes;
    }
    /**
     * Set IncludingTaxes value
     * @param bool $includingTaxes
     * @return \StructType\DiscountDefinition
     */
    public function setIncludingTaxes($includingTaxes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includingTaxes) && !is_bool($includingTaxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includingTaxes)), __LINE__);
        }
        $this->IncludingTaxes = $includingTaxes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiscountDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
