<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CostDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class CostDefinition extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The BaseCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CurrencyAmountDefinition
     */
    public $BaseCost;
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PercentageAmountDefinition
     */
    public $Commission;
    /**
     * The CostType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CostType;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Markup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PercentageAmountDefinition
     */
    public $Markup;
    /**
     * The MinSellPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CurrencyAmountDefinition
     */
    public $MinSellPrice;
    /**
     * The OverCommission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PercentageAmountDefinition
     */
    public $OverCommission;
    /**
     * The Surcharges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CurrencyAmountDefinition
     */
    public $Surcharges;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductTaxDefinition
     */
    public $Taxes;
    /**
     * Constructor method for CostDefinition
     * @uses CostDefinition::setActionType()
     * @uses CostDefinition::setBaseCost()
     * @uses CostDefinition::setCommission()
     * @uses CostDefinition::setCostType()
     * @uses CostDefinition::setId()
     * @uses CostDefinition::setMarkup()
     * @uses CostDefinition::setMinSellPrice()
     * @uses CostDefinition::setOverCommission()
     * @uses CostDefinition::setSurcharges()
     * @uses CostDefinition::setTaxes()
     * @param string $actionType
     * @param \StructType\CurrencyAmountDefinition $baseCost
     * @param \StructType\PercentageAmountDefinition $commission
     * @param string $costType
     * @param int $id
     * @param \StructType\PercentageAmountDefinition $markup
     * @param \StructType\CurrencyAmountDefinition $minSellPrice
     * @param \StructType\PercentageAmountDefinition $overCommission
     * @param \StructType\CurrencyAmountDefinition $surcharges
     * @param \ArrayType\ArrayOfProductTaxDefinition $taxes
     */
    public function __construct($actionType = null, \StructType\CurrencyAmountDefinition $baseCost = null, \StructType\PercentageAmountDefinition $commission = null, $costType = null, $id = null, \StructType\PercentageAmountDefinition $markup = null, \StructType\CurrencyAmountDefinition $minSellPrice = null, \StructType\PercentageAmountDefinition $overCommission = null, \StructType\CurrencyAmountDefinition $surcharges = null, \ArrayType\ArrayOfProductTaxDefinition $taxes = null)
    {
        $this
            ->setActionType($actionType)
            ->setBaseCost($baseCost)
            ->setCommission($commission)
            ->setCostType($costType)
            ->setId($id)
            ->setMarkup($markup)
            ->setMinSellPrice($minSellPrice)
            ->setOverCommission($overCommission)
            ->setSurcharges($surcharges)
            ->setTaxes($taxes);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\CostDefinition
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get BaseCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CurrencyAmountDefinition|null
     */
    public function getBaseCost()
    {
        return isset($this->BaseCost) ? $this->BaseCost : null;
    }
    /**
     * Set BaseCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CurrencyAmountDefinition $baseCost
     * @return \StructType\CostDefinition
     */
    public function setBaseCost(\StructType\CurrencyAmountDefinition $baseCost = null)
    {
        if (is_null($baseCost) || (is_array($baseCost) && empty($baseCost))) {
            unset($this->BaseCost);
        } else {
            $this->BaseCost = $baseCost;
        }
        return $this;
    }
    /**
     * Get Commission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PercentageAmountDefinition|null
     */
    public function getCommission()
    {
        return isset($this->Commission) ? $this->Commission : null;
    }
    /**
     * Set Commission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PercentageAmountDefinition $commission
     * @return \StructType\CostDefinition
     */
    public function setCommission(\StructType\PercentageAmountDefinition $commission = null)
    {
        if (is_null($commission) || (is_array($commission) && empty($commission))) {
            unset($this->Commission);
        } else {
            $this->Commission = $commission;
        }
        return $this;
    }
    /**
     * Get CostType value
     * @return string|null
     */
    public function getCostType()
    {
        return $this->CostType;
    }
    /**
     * Set CostType value
     * @uses \EnumType\CostType::valueIsValid()
     * @uses \EnumType\CostType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costType
     * @return \StructType\CostDefinition
     */
    public function setCostType($costType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CostType::valueIsValid($costType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $costType, implode(', ', \EnumType\CostType::getValidValues())), __LINE__);
        }
        $this->CostType = $costType;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\CostDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Markup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PercentageAmountDefinition|null
     */
    public function getMarkup()
    {
        return isset($this->Markup) ? $this->Markup : null;
    }
    /**
     * Set Markup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PercentageAmountDefinition $markup
     * @return \StructType\CostDefinition
     */
    public function setMarkup(\StructType\PercentageAmountDefinition $markup = null)
    {
        if (is_null($markup) || (is_array($markup) && empty($markup))) {
            unset($this->Markup);
        } else {
            $this->Markup = $markup;
        }
        return $this;
    }
    /**
     * Get MinSellPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CurrencyAmountDefinition|null
     */
    public function getMinSellPrice()
    {
        return isset($this->MinSellPrice) ? $this->MinSellPrice : null;
    }
    /**
     * Set MinSellPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CurrencyAmountDefinition $minSellPrice
     * @return \StructType\CostDefinition
     */
    public function setMinSellPrice(\StructType\CurrencyAmountDefinition $minSellPrice = null)
    {
        if (is_null($minSellPrice) || (is_array($minSellPrice) && empty($minSellPrice))) {
            unset($this->MinSellPrice);
        } else {
            $this->MinSellPrice = $minSellPrice;
        }
        return $this;
    }
    /**
     * Get OverCommission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PercentageAmountDefinition|null
     */
    public function getOverCommission()
    {
        return isset($this->OverCommission) ? $this->OverCommission : null;
    }
    /**
     * Set OverCommission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PercentageAmountDefinition $overCommission
     * @return \StructType\CostDefinition
     */
    public function setOverCommission(\StructType\PercentageAmountDefinition $overCommission = null)
    {
        if (is_null($overCommission) || (is_array($overCommission) && empty($overCommission))) {
            unset($this->OverCommission);
        } else {
            $this->OverCommission = $overCommission;
        }
        return $this;
    }
    /**
     * Get Surcharges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CurrencyAmountDefinition|null
     */
    public function getSurcharges()
    {
        return isset($this->Surcharges) ? $this->Surcharges : null;
    }
    /**
     * Set Surcharges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CurrencyAmountDefinition $surcharges
     * @return \StructType\CostDefinition
     */
    public function setSurcharges(\StructType\CurrencyAmountDefinition $surcharges = null)
    {
        if (is_null($surcharges) || (is_array($surcharges) && empty($surcharges))) {
            unset($this->Surcharges);
        } else {
            $this->Surcharges = $surcharges;
        }
        return $this;
    }
    /**
     * Get Taxes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductTaxDefinition|null
     */
    public function getTaxes()
    {
        return isset($this->Taxes) ? $this->Taxes : null;
    }
    /**
     * Set Taxes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductTaxDefinition $taxes
     * @return \StructType\CostDefinition
     */
    public function setTaxes(\ArrayType\ArrayOfProductTaxDefinition $taxes = null)
    {
        if (is_null($taxes) || (is_array($taxes) && empty($taxes))) {
            unset($this->Taxes);
        } else {
            $this->Taxes = $taxes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CostDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
