<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientIdentifierDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientIdentifierDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ClientIdentifierDefinition extends AbstractStructBase
{
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentIdentifierDefinition
     */
    public $Document;
    /**
     * The ProfileID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileID;
    /**
     * Constructor method for ClientIdentifierDefinition
     * @uses ClientIdentifierDefinition::setDocument()
     * @uses ClientIdentifierDefinition::setProfileID()
     * @param \StructType\DocumentIdentifierDefinition $document
     * @param int $profileID
     */
    public function __construct(\StructType\DocumentIdentifierDefinition $document = null, $profileID = null)
    {
        $this
            ->setDocument($document)
            ->setProfileID($profileID);
    }
    /**
     * Get Document value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentIdentifierDefinition|null
     */
    public function getDocument()
    {
        return isset($this->Document) ? $this->Document : null;
    }
    /**
     * Set Document value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DocumentIdentifierDefinition $document
     * @return \StructType\ClientIdentifierDefinition
     */
    public function setDocument(\StructType\DocumentIdentifierDefinition $document = null)
    {
        if (is_null($document) || (is_array($document) && empty($document))) {
            unset($this->Document);
        } else {
            $this->Document = $document;
        }
        return $this;
    }
    /**
     * Get ProfileID value
     * @return int|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param int $profileID
     * @return \StructType\ClientIdentifierDefinition
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: int
        if (!is_null($profileID) && !is_numeric($profileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClientIdentifierDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
