<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientHistoryDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientHistoryDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ClientHistoryDefinition extends AbstractStructBase
{
    /**
     * The EventDatetime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EventDatetime;
    /**
     * The ReferenceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReferenceId;
    /**
     * Constructor method for ClientHistoryDefinition
     * @uses ClientHistoryDefinition::setEventDatetime()
     * @uses ClientHistoryDefinition::setReferenceId()
     * @param string $eventDatetime
     * @param int $referenceId
     */
    public function __construct($eventDatetime = null, $referenceId = null)
    {
        $this
            ->setEventDatetime($eventDatetime)
            ->setReferenceId($referenceId);
    }
    /**
     * Get EventDatetime value
     * @return string|null
     */
    public function getEventDatetime()
    {
        return $this->EventDatetime;
    }
    /**
     * Set EventDatetime value
     * @param string $eventDatetime
     * @return \StructType\ClientHistoryDefinition
     */
    public function setEventDatetime($eventDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($eventDatetime) && !is_string($eventDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventDatetime)), __LINE__);
        }
        $this->EventDatetime = $eventDatetime;
        return $this;
    }
    /**
     * Get ReferenceId value
     * @return int|null
     */
    public function getReferenceId()
    {
        return $this->ReferenceId;
    }
    /**
     * Set ReferenceId value
     * @param int $referenceId
     * @return \StructType\ClientHistoryDefinition
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: int
        if (!is_null($referenceId) && !is_numeric($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($referenceId)), __LINE__);
        }
        $this->ReferenceId = $referenceId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClientHistoryDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
