<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirReservationItemTravelerDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AirReservationItemTravelerDefinition
 * @subpackage Structs
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class AirReservationItemTravelerDefinition extends ReservationItemTravelerDefinition
{
    /**
     * The FrequentFlyerNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerNumber;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameNumber;
    /**
     * The OtherPaxType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtherPaxType;
    /**
     * The PassengerTitle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PassengerTitle;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketNumber;
    /**
     * The Tickets
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirTicketDefinition
     */
    public $Tickets;
    /**
     * Constructor method for AirReservationItemTravelerDefinition
     * @uses AirReservationItemTravelerDefinition::setFrequentFlyerNumber()
     * @uses AirReservationItemTravelerDefinition::setNameNumber()
     * @uses AirReservationItemTravelerDefinition::setOtherPaxType()
     * @uses AirReservationItemTravelerDefinition::setPassengerTitle()
     * @uses AirReservationItemTravelerDefinition::setTicketNumber()
     * @uses AirReservationItemTravelerDefinition::setTickets()
     * @param string $frequentFlyerNumber
     * @param string $nameNumber
     * @param string $otherPaxType
     * @param int $passengerTitle
     * @param string $ticketNumber
     * @param \ArrayType\ArrayOfAirTicketDefinition $tickets
     */
    public function __construct($frequentFlyerNumber = null, $nameNumber = null, $otherPaxType = null, $passengerTitle = null, $ticketNumber = null, \ArrayType\ArrayOfAirTicketDefinition $tickets = null)
    {
        $this
            ->setFrequentFlyerNumber($frequentFlyerNumber)
            ->setNameNumber($nameNumber)
            ->setOtherPaxType($otherPaxType)
            ->setPassengerTitle($passengerTitle)
            ->setTicketNumber($ticketNumber)
            ->setTickets($tickets);
    }
    /**
     * Get FrequentFlyerNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerNumber()
    {
        return isset($this->FrequentFlyerNumber) ? $this->FrequentFlyerNumber : null;
    }
    /**
     * Set FrequentFlyerNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerNumber
     * @return \StructType\AirReservationItemTravelerDefinition
     */
    public function setFrequentFlyerNumber($frequentFlyerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerNumber) && !is_string($frequentFlyerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($frequentFlyerNumber)), __LINE__);
        }
        if (is_null($frequentFlyerNumber) || (is_array($frequentFlyerNumber) && empty($frequentFlyerNumber))) {
            unset($this->FrequentFlyerNumber);
        } else {
            $this->FrequentFlyerNumber = $frequentFlyerNumber;
        }
        return $this;
    }
    /**
     * Get NameNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameNumber()
    {
        return isset($this->NameNumber) ? $this->NameNumber : null;
    }
    /**
     * Set NameNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameNumber
     * @return \StructType\AirReservationItemTravelerDefinition
     */
    public function setNameNumber($nameNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nameNumber) && !is_string($nameNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameNumber)), __LINE__);
        }
        if (is_null($nameNumber) || (is_array($nameNumber) && empty($nameNumber))) {
            unset($this->NameNumber);
        } else {
            $this->NameNumber = $nameNumber;
        }
        return $this;
    }
    /**
     * Get OtherPaxType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtherPaxType()
    {
        return isset($this->OtherPaxType) ? $this->OtherPaxType : null;
    }
    /**
     * Set OtherPaxType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otherPaxType
     * @return \StructType\AirReservationItemTravelerDefinition
     */
    public function setOtherPaxType($otherPaxType = null)
    {
        // validation for constraint: string
        if (!is_null($otherPaxType) && !is_string($otherPaxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherPaxType)), __LINE__);
        }
        if (is_null($otherPaxType) || (is_array($otherPaxType) && empty($otherPaxType))) {
            unset($this->OtherPaxType);
        } else {
            $this->OtherPaxType = $otherPaxType;
        }
        return $this;
    }
    /**
     * Get PassengerTitle value
     * @return int|null
     */
    public function getPassengerTitle()
    {
        return $this->PassengerTitle;
    }
    /**
     * Set PassengerTitle value
     * @param int $passengerTitle
     * @return \StructType\AirReservationItemTravelerDefinition
     */
    public function setPassengerTitle($passengerTitle = null)
    {
        // validation for constraint: int
        if (!is_null($passengerTitle) && !is_numeric($passengerTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($passengerTitle)), __LINE__);
        }
        $this->PassengerTitle = $passengerTitle;
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketNumber
     * @return \StructType\AirReservationItemTravelerDefinition
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirTicketDefinition|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirTicketDefinition $tickets
     * @return \StructType\AirReservationItemTravelerDefinition
     */
    public function setTickets(\ArrayType\ArrayOfAirTicketDefinition $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirReservationItemTravelerDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
