<?php

namespace EnumType;

/**
 * This class stands for TerminalCommandType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TerminalCommandType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class TerminalCommandType
{
    /**
     * Constant for value 'Availability'
     * @return string 'Availability'
     */
    const VALUE_AVAILABILITY = 'Availability';
    /**
     * Constant for value 'ConvertCityAirportCode'
     * @return string 'ConvertCityAirportCode'
     */
    const VALUE_CONVERT_CITY_AIRPORT_CODE = 'ConvertCityAirportCode';
    /**
     * Constant for value 'ConvertCityAirportName'
     * @return string 'ConvertCityAirportName'
     */
    const VALUE_CONVERT_CITY_AIRPORT_NAME = 'ConvertCityAirportName';
    /**
     * Constant for value 'ConvertAirlineCode'
     * @return string 'ConvertAirlineCode'
     */
    const VALUE_CONVERT_AIRLINE_CODE = 'ConvertAirlineCode';
    /**
     * Constant for value 'ConvertAirlineName'
     * @return string 'ConvertAirlineName'
     */
    const VALUE_CONVERT_AIRLINE_NAME = 'ConvertAirlineName';
    /**
     * Constant for value 'ConvertCurrency'
     * @return string 'ConvertCurrency'
     */
    const VALUE_CONVERT_CURRENCY = 'ConvertCurrency';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVAILABILITY
     * @uses self::VALUE_CONVERT_CITY_AIRPORT_CODE
     * @uses self::VALUE_CONVERT_CITY_AIRPORT_NAME
     * @uses self::VALUE_CONVERT_AIRLINE_CODE
     * @uses self::VALUE_CONVERT_AIRLINE_NAME
     * @uses self::VALUE_CONVERT_CURRENCY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVAILABILITY,
            self::VALUE_CONVERT_CITY_AIRPORT_CODE,
            self::VALUE_CONVERT_CITY_AIRPORT_NAME,
            self::VALUE_CONVERT_AIRLINE_CODE,
            self::VALUE_CONVERT_AIRLINE_NAME,
            self::VALUE_CONVERT_CURRENCY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
