<?php

namespace EnumType;

/**
 * This class stands for ReservationItemType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationItemType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ReservationItemType
{
    /**
     * Constant for value 'Base'
     * @return string 'Base'
     */
    const VALUE_BASE = 'Base';
    /**
     * Constant for value 'Air'
     * @return string 'Air'
     */
    const VALUE_AIR = 'Air';
    /**
     * Constant for value 'Hotel'
     * @return string 'Hotel'
     */
    const VALUE_HOTEL = 'Hotel';
    /**
     * Constant for value 'Vehicle'
     * @return string 'Vehicle'
     */
    const VALUE_VEHICLE = 'Vehicle';
    /**
     * Constant for value 'TravelExtra'
     * @return string 'TravelExtra'
     */
    const VALUE_TRAVEL_EXTRA = 'TravelExtra';
    /**
     * Constant for value 'Package'
     * @return string 'Package'
     */
    const VALUE_PACKAGE = 'Package';
    /**
     * Constant for value 'Bus'
     * @return string 'Bus'
     */
    const VALUE_BUS = 'Bus';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BASE
     * @uses self::VALUE_AIR
     * @uses self::VALUE_HOTEL
     * @uses self::VALUE_VEHICLE
     * @uses self::VALUE_TRAVEL_EXTRA
     * @uses self::VALUE_PACKAGE
     * @uses self::VALUE_BUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASE,
            self::VALUE_AIR,
            self::VALUE_HOTEL,
            self::VALUE_VEHICLE,
            self::VALUE_TRAVEL_EXTRA,
            self::VALUE_PACKAGE,
            self::VALUE_BUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
