<?php

namespace EnumType;

/**
 * This class stands for ProfilePhoneType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfilePhoneType
 * @subpackage Enumerations
 * @Autor Luis Vasquez
 * @Fecha 20 Agosto 2018
 * @Versión 1.3
 * @Proyecto  Netactica
 */
class ProfilePhoneType
{
    /**
     * Constant for value 'Fixed'
     * @return string 'Fixed'
     */
    const VALUE_FIXED = 'Fixed';
    /**
     * Constant for value 'Mobile'
     * @return string 'Mobile'
     */
    const VALUE_MOBILE = 'Mobile';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIXED
     * @uses self::VALUE_MOBILE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIXED,
            self::VALUE_MOBILE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
